/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.core.libraryselector;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.platform.picture.core.ImageUtils;
import org.nuxeo.ecm.platform.picture.core.MetadataUtils;
import org.nuxeo.ecm.platform.picture.core.libraryselector.LibrarySelector;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class LibrarySelectorService
extends DefaultComponent
implements LibrarySelector {
    private static final Logger log = LogManager.getLogger(LibrarySelectorService.class);
    public static final String LIBRARY_SELECTOR = "LibrarySelector";
    protected ImageUtils imageUtils;

    public void start(ComponentContext context) {
        this.getRegistryContribution(LIBRARY_SELECTOR).ifPresent(desc -> {
            try {
                this.imageUtils = desc.getNewInstance();
            }
            catch (ReflectiveOperationException e) {
                String message = String.format("Cannot create image utils: %s", e.getMessage());
                log.error(message, (Throwable)e);
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, message);
            }
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = this.imageUtils::getClass;
            log.debug("Using '{}' for ImageUtils.", supplierArray);
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.imageUtils = null;
    }

    @Override
    public ImageUtils getImageUtils() {
        return this.imageUtils;
    }

    @Override
    public MetadataUtils getMetadataUtils() {
        return null;
    }
}

