/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.DuplicateKeyException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoException;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.MongoQueryException;
import com.mongodb.MongoSocketReadTimeoutException;
import com.mongodb.MongoWriteException;
import com.mongodb.WriteError;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Spliterators;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.api.lock.LockManager;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSConnection;
import org.nuxeo.ecm.core.storage.dbs.DBSConnectionBase;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryBase;
import org.nuxeo.ecm.core.storage.dbs.DBSStateFlattener;
import org.nuxeo.ecm.core.storage.dbs.DBSTransactionState;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBConverter;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBCursorService;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepository;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryQueryBuilder;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class MongoDBConnection
extends DBSConnectionBase {
    private static final Logger log = LogManager.getLogger(MongoDBConnection.class);
    protected static final Random RANDOM = new SecureRandom();
    protected final MongoDBRepository mongoDBRepository;
    protected final MongoCollection<Document> coll;
    protected final String idKey;
    protected final boolean useCustomId;
    protected long sequenceLeft;
    protected long sequenceLastValue;
    protected final MongoDBConverter converter;
    protected ClientSession clientSession;
    protected boolean transactionStarted;
    protected static final int NB_TRY = 15;
    protected static final Bson LOCK_FIELDS = Projections.include((String[])new String[]{"ecm:lockOwner", "ecm:lockCreated"});
    protected static final Bson UNSET_LOCK_UPDATE = Updates.combine((Bson[])new Bson[]{Updates.unset((String)"ecm:lockOwner"), Updates.unset((String)"ecm:lockCreated")});

    public MongoDBConnection(MongoDBRepository repository) {
        super((DBSRepositoryBase)repository);
        this.mongoDBRepository = repository;
        this.coll = repository.getCollection();
        this.idKey = repository.getIdKey();
        this.useCustomId = "ecm:id".equals(this.idKey);
        this.converter = repository.getConverter();
        this.clientSession = repository.supportsSessions() ? repository.getClient().startSession() : null;
        this.initRepository(repository.descriptor);
    }

    public void close() {
        if (this.clientSession != null) {
            this.clientSession.close();
            this.clientSession = null;
        }
    }

    public void begin() {
        if (this.clientSession != null) {
            this.clientSession.startTransaction();
            this.transactionStarted = true;
        }
    }

    public void commit() {
        if (this.clientSession != null) {
            try {
                this.clientSession.commitTransaction();
            }
            finally {
                this.transactionStarted = false;
            }
        }
    }

    public void rollback() {
        if (this.clientSession != null) {
            try {
                this.clientSession.abortTransaction();
            }
            finally {
                this.transactionStarted = false;
            }
        }
    }

    protected void initRepository(MongoDBRepositoryDescriptor descriptor) {
        DBSRepositoryBase.IdType idType;
        if (this.coll.countDocuments(this.converter.filterEq("ecm:id", this.getRootId())) > 0L) {
            this.mongoDBRepository.readSettings();
            return;
        }
        if (this.useCustomId) {
            this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:id"}), new IndexOptions().unique(true));
        }
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:parentId"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:ancestorIds"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:versionSeriesId"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:proxyTargetId"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:proxyVersionSeriesId"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:racl"}));
        IndexOptions parentNameIndexOptions = new IndexOptions();
        if (descriptor != null) {
            parentNameIndexOptions.unique(Boolean.TRUE.equals(descriptor.getChildNameUniqueConstraintEnabled()));
        }
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:parentId", "ecm:name"}), parentNameIndexOptions);
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:primaryType"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:lifeCycleState"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:isTrashed"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:retainUntil"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:blobKeys"}));
        if (!this.repository.isFulltextDisabled()) {
            this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:fulltextJobId"}));
        }
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:acp.acl.user"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"ecm:acp.acl.status"}));
        this.coll.createIndex(Indexes.descending((String[])new String[]{"dc:modified"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"rend:renditionName"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"rend:sourceId"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"rend:sourceVersionableId"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"drv:subscriptions.enabled"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"collectionMember:collectionIds"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"nxtag:tags"}));
        this.coll.createIndex(Indexes.ascending((String[])new String[]{"coldstorage:beingRetrieved"}));
        if (!this.repository.isFulltextSearchDisabled()) {
            Bson indexKeys = Indexes.compoundIndex((Bson[])new Bson[]{Indexes.text((String)"ecm:fulltextSimple"), Indexes.text((String)"ecm:fulltextBinary")});
            IndexOptions indexOptions = new IndexOptions().name("fulltext").languageOverride("__language");
            this.coll.createIndex(indexKeys, indexOptions);
        }
        if ((idType = this.repository.getIdType()) == DBSRepositoryBase.IdType.sequence || idType == DBSRepositoryBase.IdType.sequenceHexRandomized) {
            long counter = idType == DBSRepositoryBase.IdType.sequenceHexRandomized ? this.randomInitialSeed() : 0L;
            MongoCollection<Document> countersColl = this.mongoDBRepository.getCountersCollection();
            Document idCounter = new Document();
            idCounter.put("_id", (Object)"ecm:id");
            idCounter.put("seq", (Object)counter);
            countersColl.insertOne((Object)idCounter);
        }
        this.mongoDBRepository.initSettings();
        this.initRoot();
    }

    protected synchronized long getNextSequenceId() {
        long sequenceBlockSize = this.mongoDBRepository.sequenceBlockSize;
        if (this.repository.getIdType() == DBSRepositoryBase.IdType.sequence) {
            if (this.sequenceLeft == 0L) {
                this.sequenceLeft = sequenceBlockSize;
                this.sequenceLastValue = this.updateSequence();
            }
            ++this.sequenceLastValue;
        } else {
            if (this.sequenceLeft == 0L) {
                this.sequenceLeft = sequenceBlockSize;
                this.sequenceLastValue = this.updateRandomizedSequence();
            }
            this.sequenceLastValue = this.xorshift(this.sequenceLastValue);
        }
        --this.sequenceLeft;
        return this.sequenceLastValue;
    }

    protected long updateSequence() {
        Bson update;
        Bson filter;
        long sequenceBlockSize = this.mongoDBRepository.sequenceBlockSize;
        MongoCollection<Document> countersColl = this.mongoDBRepository.getCountersCollection();
        Document idCounter = (Document)countersColl.findOneAndUpdate(filter = Filters.eq((String)"_id", (Object)"ecm:id"), update = Updates.inc((String)"seq", (Number)sequenceBlockSize), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        if (idCounter == null) {
            throw new NuxeoException("Repository id counter not initialized");
        }
        return idCounter.getLong((Object)"seq") - sequenceBlockSize;
    }

    protected Long tryUpdateRandomizedSequence() {
        boolean updated;
        Bson filter;
        long sequenceBlockSize = this.mongoDBRepository.sequenceBlockSize;
        MongoCollection<Document> countersColl = this.mongoDBRepository.getCountersCollection();
        Document res = (Document)countersColl.find(filter = Filters.eq((String)"_id", (Object)"ecm:id")).first();
        if (res == null) {
            throw new NuxeoException("Failed to read " + filter + " in collection " + countersColl.getNamespace());
        }
        Long lastValue = res.getLong((Object)"seq");
        long newValue = this.xorshift(lastValue, sequenceBlockSize);
        Bson updateFilter = Filters.and((Bson[])new Bson[]{filter, Filters.eq((String)"seq", (Object)lastValue)});
        Bson update = Updates.set((String)"seq", (Object)newValue);
        log.trace("MongoDB: FINDANDMODIFY {} UPDATE {}", (Object)updateFilter, (Object)update);
        boolean bl = updated = countersColl.findOneAndUpdate(updateFilter, update) != null;
        if (updated) {
            return lastValue;
        }
        log.trace("MongoDB:    -> FAILED (will retry)");
        return null;
    }

    protected long updateRandomizedSequence() {
        long sleepDuration = 1L;
        for (int i = 0; i < 15; ++i) {
            Long value = this.tryUpdateRandomizedSequence();
            if (value != null) {
                return value;
            }
            try {
                Thread.sleep(sleepDuration);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new NuxeoException();
            }
            sleepDuration *= 2L;
            sleepDuration += System.nanoTime() % 4L;
        }
        throw new ConcurrentUpdateException("Failed to update randomized sequence");
    }

    protected long randomInitialSeed() {
        long seed;
        while ((seed = RANDOM.nextLong()) == 0L) {
        }
        return seed;
    }

    protected long xorshift(long n, long times) {
        for (long i = 0L; i < times; ++i) {
            n = this.xorshift(n);
        }
        return n;
    }

    protected long xorshift(long n) {
        n ^= n << 13;
        n ^= n >>> 7;
        n ^= n << 17;
        return n;
    }

    public String generateNewId() {
        DBSRepositoryBase.IdType idType = this.repository.getIdType();
        if (idType == DBSRepositoryBase.IdType.sequence || idType == DBSRepositoryBase.IdType.sequenceHexRandomized) {
            long id = this.getNextSequenceId();
            if (idType == DBSRepositoryBase.IdType.sequence) {
                return String.valueOf(id);
            }
            Object hex = Long.toHexString(id);
            int nz = 16 - ((String)hex).length();
            if (nz > 0) {
                hex = "0".repeat(nz) + (String)hex;
            }
            return hex;
        }
        return UUID.randomUUID().toString();
    }

    public void createState(State state) {
        Document doc = this.converter.stateToBson(state);
        log.trace("MongoDB: CREATE {}: {}", doc.get((Object)this.idKey), (Object)doc);
        try {
            this.insertOne(doc);
        }
        catch (DuplicateKeyException dke) {
            log.trace("MongoDB:    -> DUPLICATE KEY: {}", doc.get((Object)this.idKey));
            throw new ConcurrentUpdateException((Throwable)dke);
        }
    }

    public void createStates(List<State> states) {
        List<Document> docs = states.stream().map(this.converter::stateToBson).collect(Collectors.toList());
        log.trace("MongoDB: CREATE [{}]: {}", new Supplier[]{() -> docs.stream().map(doc -> doc.get((Object)this.idKey).toString()).collect(Collectors.joining(", ")), () -> docs});
        try {
            this.insertMany(docs);
        }
        catch (MongoBulkWriteException mbwe) {
            List<String> duplicates = mbwe.getWriteErrors().stream().filter(wr -> ErrorCategory.DUPLICATE_KEY.equals((Object)ErrorCategory.fromErrorCode((int)wr.getCode()))).map(WriteError::getMessage).collect(Collectors.toList());
            if (duplicates.size() == mbwe.getWriteErrors().size()) {
                log.trace("MongoDB:    -> DUPLICATE KEY: {}", duplicates);
                ConcurrentUpdateException concurrentUpdateException = new ConcurrentUpdateException("Concurrent update");
                duplicates.forEach(arg_0 -> ((ConcurrentUpdateException)concurrentUpdateException).addInfo(arg_0));
                throw concurrentUpdateException;
            }
            throw mbwe;
        }
    }

    public State readState(String id) {
        return this.findOne(this.converter.filterEq("ecm:id", id));
    }

    public State readPartialState(String id, Collection<String> keys) {
        Document fields = new Document();
        keys.forEach(key -> fields.put(this.converter.keyToBson((String)key), (Object)MongoDBRepository.ONE));
        return this.findOne(this.converter.filterEq("ecm:id", id), (Bson)fields);
    }

    public List<State> readStates(List<String> ids) {
        return this.findAll(this.converter.filterIn("ecm:id", ids));
    }

    public void updateState(String id, State.StateDiff diff, DBSTransactionState.ChangeTokenUpdater changeTokenUpdater) {
        List<Document> updates = this.converter.diffToBson(diff);
        for (Document update : updates) {
            Document filter = new Document();
            this.converter.putToBson(filter, "ecm:id", id);
            if (changeTokenUpdater == null) {
                log.trace("MongoDB: UPDATE {}: {}", (Object)id, (Object)update);
            } else {
                Map conditions = changeTokenUpdater.getConditions();
                Map tokenUpdates = changeTokenUpdater.getUpdates();
                if (update.containsKey((Object)"$set")) {
                    ((Document)update.get((Object)"$set")).putAll(tokenUpdates);
                } else {
                    Document set = new Document();
                    set.putAll(tokenUpdates);
                    update.put("$set", (Object)set);
                }
                log.trace("MongoDB: UPDATE {}: IF {} THEN {}", (Object)id, (Object)conditions, (Object)update);
                filter.putAll(conditions);
            }
            try {
                UpdateResult w = this.updateMany((Bson)filter, (Bson)update);
                if (w.getModifiedCount() == 1L) continue;
                log.trace("MongoDB:    -> CONCURRENT UPDATE: {}", (Object)id);
                throw new ConcurrentUpdateException(id);
            }
            catch (MongoWriteException mwe) {
                if (ErrorCategory.DUPLICATE_KEY.equals((Object)ErrorCategory.fromErrorCode((int)mwe.getCode()))) {
                    log.trace("MongoDB:    -> DUPLICATE KEY: {}", (Object)id);
                    throw new ConcurrentUpdateException(mwe.getError().getMessage(), (Throwable)mwe);
                }
                throw mwe;
            }
        }
    }

    public void deleteStates(Set<String> ids) {
        Bson filter = this.converter.filterIn("ecm:id", ids);
        log.trace("MongoDB: REMOVE {}", ids);
        DeleteResult w = this.deleteMany(filter);
        if (w.getDeletedCount() != (long)ids.size()) {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> ((DeleteResult)w).getDeletedCount();
            supplierArray[1] = ids::size;
            supplierArray[2] = () -> ids;
            log.debug("Removed {} docs for {} ids: {}", supplierArray);
        }
    }

    public State readChildState(String parentId, String name, Set<String> ignored) {
        Document filter = this.getChildQuery(parentId, name, ignored);
        return this.findOne((Bson)filter);
    }

    protected NuxeoException newQueryException(String message, MongoException cause, Bson filter) {
        NuxeoException exc = new NuxeoException(message, (Throwable)cause);
        if (filter != null) {
            String msg = filter instanceof Document ? ((Document)filter).toJson() : filter.toString();
            exc.addInfo("Filter: " + msg);
        }
        return exc;
    }

    protected NuxeoException newQueryTimeout(MongoException cause, Bson filter) {
        return this.newQueryException("Query timed out as a result of the maximum operation time being exceeded", cause, filter);
    }

    protected NuxeoException newQueryTimeoutClient(MongoException cause, Bson filter) {
        return this.newQueryException("Query timed out on client side after socketTimeout exceeded", cause, filter);
    }

    protected NuxeoException newQueryFailure(MongoException cause, Bson filter) {
        return this.newQueryException("Query operation failed on the server", cause, filter);
    }

    protected void logQuery(String id, Bson fields) {
        this.logQuery(this.converter.filterEq("ecm:id", id), fields);
    }

    protected void logQuery(Bson filter, Bson fields) {
        if (fields == null) {
            log.trace("MongoDB: QUERY {}", (Object)filter);
        } else {
            log.trace("MongoDB: QUERY {} KEYS {}", (Object)filter, (Object)fields);
        }
    }

    protected void logQuery(Bson query, Bson fields, Bson orderBy, int limit, int offset) {
        if (orderBy == null) {
            log.trace("MongoDB: QUERY {} KEYS {} OFFSET {} LIMIT {}", (Object)query, (Object)fields, (Object)offset, (Object)limit);
        } else {
            log.trace("MongoDB: QUERY {} KEYS {} ORDER BY {} OFFSET {} LIMIT {}", (Object)query, (Object)fields, (Object)orderBy, (Object)offset, (Object)limit);
        }
    }

    public boolean hasChild(String parentId, String name, Set<String> ignored) {
        Document filter = this.getChildQuery(parentId, name, ignored);
        return this.exists((Bson)filter);
    }

    protected Document getChildQuery(String parentId, String name, Set<String> ignored) {
        Document filter = new Document();
        this.converter.putToBson(filter, "ecm:parentId", parentId);
        this.converter.putToBson(filter, "ecm:name", name);
        this.addIgnoredIds(filter, ignored);
        return filter;
    }

    protected void addIgnoredIds(Document filter, Set<String> ignored) {
        if (!ignored.isEmpty()) {
            Document notInIds = new Document("$nin", this.converter.listToBson("ecm:id", ignored));
            filter.put(this.idKey, (Object)notInIds);
        }
    }

    public List<State> queryKeyValue(String key, Object value, Set<String> ignored) {
        Document filter = new Document();
        this.converter.putToBson(filter, key, value);
        this.addIgnoredIds(filter, ignored);
        return this.findAll((Bson)filter);
    }

    public List<State> queryKeyValue(String key1, Object value1, String key2, Object value2, Set<String> ignored) {
        Document filter = new Document();
        this.converter.putToBson(filter, key1, value1);
        this.converter.putToBson(filter, key2, value2);
        this.addIgnoredIds(filter, ignored);
        return this.findAll((Bson)filter);
    }

    public List<State> queryKeyValueWithOperator(String key1, Object value1, String key2, DBSConnection.DBSQueryOperator operator, Object value2, Set<String> ignored) {
        Map<String, Object> comparatorAndValue;
        switch (operator) {
            case IN: {
                comparatorAndValue = Map.of("$in", value2);
                break;
            }
            case NOT_IN: {
                comparatorAndValue = Map.of("$nin", value2);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown operator: %s", operator));
            }
        }
        Document filter = new Document();
        this.converter.putToBson(filter, key1, value1);
        this.converter.putToBson(filter, key2, comparatorAndValue);
        this.addIgnoredIds(filter, ignored);
        return this.findAll((Bson)filter);
    }

    public Stream<State> getDescendants(String rootId, Set<String> keys) {
        return this.getDescendants(rootId, keys, 0);
    }

    public Stream<State> getDescendants(String rootId, Set<String> keys, int limit) {
        Bson filter = this.converter.filterEq("ecm:ancestorIds", rootId);
        Document fields = new Document();
        if (this.useCustomId) {
            fields.put("_id", (Object)MongoDBRepository.ZERO);
        }
        fields.put(this.idKey, (Object)MongoDBRepository.ONE);
        keys.forEach(key -> fields.put(this.converter.keyToBson((String)key), (Object)MongoDBRepository.ONE));
        return this.stream(filter, (Bson)fields, limit);
    }

    public boolean queryKeyValuePresence(String key, String value, Set<String> ignored) {
        Document filter = new Document();
        this.converter.putToBson(filter, key, value);
        this.addIgnoredIds(filter, ignored);
        return this.exists((Bson)filter);
    }

    protected boolean exists(Bson filter) {
        return this.exists(filter, (Bson)this.justPresenceField());
    }

    protected boolean exists(Bson filter, Bson projection) {
        this.logQuery(filter, projection);
        try {
            return this.find(filter).projection(projection).first() != null;
        }
        catch (MongoExecutionTimeoutException e) {
            throw this.newQueryTimeout((MongoException)e, filter);
        }
        catch (MongoSocketReadTimeoutException e) {
            throw this.newQueryTimeoutClient((MongoException)e, filter);
        }
        catch (MongoQueryException e) {
            throw this.newQueryFailure((MongoException)e, filter);
        }
    }

    protected State findOne(Bson filter) {
        return this.findOne(filter, null);
    }

    protected State findOne(Bson filter, Bson projection) {
        try (Stream<State> stream = this.stream(filter, projection);){
            State state = stream.findAny().orElse(null);
            return state;
        }
    }

    protected List<State> findAll(Bson filter) {
        List<State> list;
        block10: {
            Stream<State> stream = this.stream(filter);
            try {
                list = stream.collect(Collectors.toList());
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoExecutionTimeoutException e) {
                    throw this.newQueryTimeout((MongoException)e, filter);
                }
                catch (MongoSocketReadTimeoutException e) {
                    throw this.newQueryTimeoutClient((MongoException)e, filter);
                }
                catch (MongoQueryException e) {
                    throw this.newQueryFailure((MongoException)e, filter);
                }
            }
            stream.close();
        }
        return list;
    }

    protected Stream<State> stream(Bson filter) {
        return this.stream(filter, null, 0);
    }

    protected Stream<State> stream(Bson filter, Bson projection) {
        return this.stream(filter, projection, 0);
    }

    protected Stream<State> stream(Bson filter, Bson projection, int limit) {
        if (filter == null) {
            filter = new Document();
        }
        this.logQuery(filter, projection);
        boolean completedAbruptly = true;
        MongoCursor cursor = this.find(filter).limit(limit).projection(projection).iterator();
        try {
            HashSet seen = new HashSet();
            Stream<State> stream = ((Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(cursor, 0), false).onClose(() -> ((MongoCursor)cursor).close())).filter(doc -> seen.add(doc.get((Object)this.idKey))).map(this.converter::bsonToState);
            completedAbruptly = false;
            Stream<State> stream2 = stream;
            return stream2;
        }
        catch (MongoExecutionTimeoutException e) {
            throw this.newQueryTimeout((MongoException)e, filter);
        }
        catch (MongoSocketReadTimeoutException e) {
            throw this.newQueryTimeoutClient((MongoException)e, filter);
        }
        catch (MongoQueryException e) {
            throw this.newQueryFailure((MongoException)e, filter);
        }
        finally {
            if (completedAbruptly) {
                cursor.close();
            }
        }
    }

    protected Document justPresenceField() {
        return new Document("_id", (Object)MongoDBRepository.ONE);
    }

    public PartialList<Map<String, Serializable>> queryAndFetch(DBSExpressionEvaluator evaluator, OrderByClause orderByClause, boolean distinctDocuments, int limit, int offset, int countUpTo) {
        long totalSize;
        ArrayList<Map> projections;
        boolean manualProjection;
        MongoDBRepositoryQueryBuilder builder = new MongoDBRepositoryQueryBuilder((MongoDBRepository)this.repository, evaluator.getExpression(), evaluator.getSelectClause(), orderByClause, evaluator.pathResolver, evaluator.fulltextSearchDisabled);
        builder.walk();
        if (builder.hasFulltext && this.repository.isFulltextSearchDisabled()) {
            throw new QueryParseException("Fulltext search disabled by configuration");
        }
        Document filter = builder.getQuery();
        this.addPrincipals(filter, evaluator.principals);
        Document orderBy = builder.getOrderBy();
        Document keys = builder.getProjection();
        boolean bl = manualProjection = !distinctDocuments && builder.hasProjectionWildcard();
        if (manualProjection) {
            keys = null;
            evaluator.parse();
        }
        this.logQuery((Bson)filter, (Bson)keys, (Bson)orderBy, limit, offset);
        try (MongoCursor cursor = this.find((Bson)filter).projection((Bson)keys).skip(offset).limit(limit).sort((Bson)orderBy).iterator();){
            projections = new ArrayList<Map>();
            DBSStateFlattener flattener = new DBSStateFlattener(builder.propertyKeys);
            Iterable docs = () -> cursor;
            for (Document doc : docs) {
                State state = this.converter.bsonToState(doc);
                if (manualProjection) {
                    projections.addAll(evaluator.matches(state));
                    continue;
                }
                projections.add(flattener.flatten(state));
            }
        }
        catch (MongoExecutionTimeoutException e) {
            throw this.newQueryTimeout((MongoException)e, (Bson)filter);
        }
        catch (MongoSocketReadTimeoutException e) {
            throw this.newQueryTimeoutClient((MongoException)e, (Bson)filter);
        }
        catch (MongoQueryException e) {
            throw this.newQueryFailure((MongoException)e, (Bson)filter);
        }
        if (countUpTo == -1) {
            totalSize = limit == 0 ? (long)projections.size() : (manualProjection ? -1L : this.countDocuments((Bson)filter));
        } else if (countUpTo == 0) {
            totalSize = -1L;
        } else {
            totalSize = limit == 0 ? (long)projections.size() : (manualProjection ? -1L : this.countDocuments((Bson)filter, new CountOptions().limit(countUpTo + 1)));
            if (totalSize > (long)countUpTo) {
                totalSize = -2L;
            }
        }
        if (!projections.isEmpty()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = projections::size;
            log.trace("MongoDB:    -> {}", supplierArray);
        }
        return new PartialList(projections, totalSize);
    }

    public ScrollResult<String> scroll(DBSExpressionEvaluator evaluator, int batchSize, int keepAliveSeconds) {
        MongoCursor cursor;
        MongoDBCursorService cursorService = this.mongoDBRepository.getCursorService();
        cursorService.checkForTimedOutScroll();
        MongoDBRepositoryQueryBuilder builder = new MongoDBRepositoryQueryBuilder((MongoDBRepository)this.repository, evaluator.getExpression(), evaluator.getSelectClause(), null, evaluator.pathResolver, evaluator.fulltextSearchDisabled);
        builder.walk();
        if (builder.hasFulltext && this.repository.isFulltextSearchDisabled()) {
            throw new QueryParseException("Fulltext search disabled by configuration");
        }
        Document filter = builder.getQuery();
        this.addPrincipals(filter, evaluator.principals);
        Document keys = builder.getProjection();
        this.logQuery((Bson)filter, (Bson)keys, null, 0, 0);
        try {
            cursor = this.find((Bson)filter).projection((Bson)keys).batchSize(batchSize).iterator();
            cursor.hasNext();
        }
        catch (MongoExecutionTimeoutException e) {
            throw this.newQueryTimeout((MongoException)e, (Bson)filter);
        }
        catch (MongoSocketReadTimeoutException e) {
            throw this.newQueryTimeoutClient((MongoException)e, (Bson)filter);
        }
        catch (MongoQueryException e) {
            throw this.newQueryFailure((MongoException)e, (Bson)filter);
        }
        String scrollId = cursorService.registerCursor(cursor, batchSize, keepAliveSeconds);
        return this.scroll(scrollId);
    }

    public ScrollResult<String> scroll(String scrollId) {
        MongoDBCursorService cursorService = this.mongoDBRepository.getCursorService();
        try {
            return cursorService.scroll(scrollId);
        }
        catch (MongoExecutionTimeoutException e) {
            throw this.newQueryTimeout((MongoException)e, null);
        }
        catch (MongoSocketReadTimeoutException e) {
            throw this.newQueryTimeoutClient((MongoException)e, null);
        }
        catch (MongoQueryException e) {
            throw this.newQueryFailure((MongoException)e, null);
        }
    }

    protected void addPrincipals(Document query, Set<String> principals) {
        if (principals != null) {
            Document inPrincipals = new Document("$in", new ArrayList<String>(principals));
            query.put("ecm:racl", (Object)inPrincipals);
        }
    }

    public Lock getLock(String id) {
        this.logQuery(id, LOCK_FIELDS);
        Document res = (Document)this.coll.find(this.converter.filterEq("ecm:id", id)).projection(LOCK_FIELDS).first();
        if (res == null) {
            throw new DocumentNotFoundException(id);
        }
        String owner = res.getString((Object)"ecm:lockOwner");
        if (owner == null) {
            return null;
        }
        Calendar created = (Calendar)this.converter.bsonToSerializable("ecm:lockCreated", res.get((Object)"ecm:lockCreated"));
        return new Lock(owner, created);
    }

    public Lock setLock(String id, Lock lock) {
        Bson filter = Filters.and((Bson[])new Bson[]{this.converter.filterEq("ecm:id", id), Filters.exists((String)"ecm:lockOwner", (boolean)false)});
        Bson setLock = Updates.combine((Bson[])new Bson[]{Updates.set((String)"ecm:lockOwner", (Object)lock.getOwner()), Updates.set((String)"ecm:lockCreated", (Object)this.converter.serializableToBson("ecm:lockCreated", lock.getCreated()))});
        log.trace("MongoDB: FINDANDMODIFY {} UPDATE {}", (Object)filter, (Object)setLock);
        Document res = (Document)this.coll.findOneAndUpdate(filter, setLock);
        if (res != null) {
            return null;
        }
        this.logQuery(id, LOCK_FIELDS);
        Document old = (Document)this.coll.find(this.converter.filterEq("ecm:id", id)).projection(LOCK_FIELDS).first();
        if (old == null) {
            throw new DocumentNotFoundException(id);
        }
        String oldOwner = (String)old.get((Object)"ecm:lockOwner");
        Calendar oldCreated = (Calendar)this.converter.bsonToSerializable("ecm:lockCreated", old.get((Object)"ecm:lockCreated"));
        if (oldOwner != null) {
            return new Lock(oldOwner, oldCreated);
        }
        throw new ConcurrentUpdateException("Lock " + id);
    }

    public Lock removeLock(String id, String owner) {
        Document filter = new Document();
        this.converter.putToBson(filter, "ecm:id", id);
        if (owner != null) {
            List<String> ownerOrNull = Arrays.asList(owner, null);
            filter.put("ecm:lockOwner", (Object)new Document("$in", ownerOrNull));
        }
        log.trace("MongoDB: FINDANDMODIFY {} UPDATE {}", (Object)filter, (Object)UNSET_LOCK_UPDATE);
        Document old = (Document)this.coll.findOneAndUpdate((Bson)filter, UNSET_LOCK_UPDATE);
        if (old != null) {
            String oldOwner = (String)old.get((Object)"ecm:lockOwner");
            if (oldOwner == null) {
                return null;
            }
            Calendar oldCreated = (Calendar)this.converter.bsonToSerializable("ecm:lockCreated", old.get((Object)"ecm:lockCreated"));
            return new Lock(oldOwner, oldCreated);
        }
        this.logQuery(id, LOCK_FIELDS);
        old = (Document)this.coll.find(this.converter.filterEq("ecm:id", id)).projection(LOCK_FIELDS).first();
        if (old == null) {
            throw new DocumentNotFoundException(id);
        }
        String oldOwner = (String)old.get((Object)"ecm:lockOwner");
        Calendar oldCreated = (Calendar)this.converter.bsonToSerializable("ecm:lockCreated", old.get((Object)"ecm:lockCreated"));
        if (oldOwner != null) {
            if (!LockManager.canLockBeRemoved((String)oldOwner, (String)owner)) {
                return new Lock(oldOwner, oldCreated, true);
            }
            throw new ConcurrentUpdateException("Unlock " + id);
        }
        throw new ConcurrentUpdateException("Unlock " + id);
    }

    protected void insertOne(Document document) {
        if (this.transactionStarted) {
            this.coll.insertOne(this.clientSession, (Object)document);
        } else {
            this.coll.insertOne((Object)document);
        }
    }

    protected void insertMany(List<Document> documents) {
        if (this.transactionStarted) {
            this.coll.insertMany(this.clientSession, documents);
        } else {
            this.coll.insertMany(documents);
        }
    }

    protected UpdateResult updateMany(Bson filter, Bson update) {
        if (this.transactionStarted) {
            return this.coll.updateMany(this.clientSession, filter, update);
        }
        return this.coll.updateMany(filter, update);
    }

    protected DeleteResult deleteMany(Bson filter) {
        if (this.transactionStarted) {
            return this.coll.deleteMany(this.clientSession, filter);
        }
        return this.coll.deleteMany(filter);
    }

    protected FindIterable<Document> find(Bson filter) {
        FindIterable it = this.transactionStarted ? this.coll.find(this.clientSession, filter) : this.coll.find(filter);
        it.maxTime(this.getMaxTimeMs(), TimeUnit.MILLISECONDS);
        return it;
    }

    protected long getMaxTimeMs() {
        long ttl = TransactionHelper.getTransactionTimeToLive();
        return ttl < 0L ? this.mongoDBRepository.maxTimeMS : ttl * 1000L + 250L;
    }

    protected long countDocuments(Bson filter) {
        return this.countDocuments(filter, new CountOptions());
    }

    protected long countDocuments(Bson filter, CountOptions options) {
        options.maxTime(this.getMaxTimeMs(), TimeUnit.MILLISECONDS);
        if (this.transactionStarted) {
            return this.coll.countDocuments(this.clientSession, filter, options);
        }
        return this.coll.countDocuments(filter, options);
    }
}

