/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.ecm.core.storage.dbs.AbstractDBSRepositoryDescriptorRegistry;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryFactory;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.model.DefaultComponent;
import org.w3c.dom.Element;

public class MongoDBRepositoryService
extends DefaultComponent {
    protected static final String COMPONENT_NAME = "org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryService";
    protected static final String XP = "repository";

    public static final class Registry
    extends AbstractDBSRepositoryDescriptorRegistry {
        public Registry() {
            super(MongoDBRepositoryService.COMPONENT_NAME, MongoDBRepositoryService.XP, MongoDBRepositoryFactory.class);
        }

        protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
            MongoDBRepositoryDescriptor contrib = (MongoDBRepositoryDescriptor)((Object)super.doRegister(ctx, xObject, element, extensionId));
            if (StringUtils.isNotBlank((CharSequence)contrib.server) || StringUtils.isNotBlank((CharSequence)contrib.dbname)) {
                String msg = String.format("MongoDB repository contribution with name '%s' holds 'server' or 'dbname' elements that should be contributed to extension point '%s--%s' since 9.3", contrib.name, "org.nuxeo.runtime.mongodb.MongoDBComponent", "connection");
                DeprecationLogger.log((String)msg, (String)"9.3");
                Framework.getRuntime().getMessageHandler().addMessage(new RuntimeMessage(RuntimeMessage.Level.ERROR, msg, RuntimeMessage.Source.EXTENSION, extensionId));
            }
            return (T)((Object)contrib);
        }
    }
}

