/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.operation;

import java.io.Serializable;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.query.sql.NXQL;

@Operation(id="Document.UnpublishAll", category="Document", label="Unpublish Document's Publications", description="Unpublish all publications of the input document. Only publications that current user can remove will be unpublished.")
public class UnpublishAll {
    public static final String ID = "Document.UnpublishAll";
    @Context
    protected CoreSession session;

    @OperationMethod
    public void run(DocumentModel doc) {
        String escapedId = NXQL.escapeString((String)doc.getId());
        this.session.queryProjection(String.format("SELECT * FROM Document WHERE ecm:isProxy = 1 AND (rend:sourceVersionableId = %s OR ecm:proxyVersionableId = %s)", escapedId, escapedId), 0L, 0L).stream().map(publication -> new IdRef(((Serializable)publication.get("ecm:uuid")).toString())).filter(arg_0 -> ((CoreSession)this.session).canRemoveDocument(arg_0)).forEach(arg_0 -> ((CoreSession)this.session).removeDocument(arg_0));
    }
}

