/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.rendition.impl.StoredRendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionCreator;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionFinder;
import org.nuxeo.ecm.platform.rendition.service.StoredRenditionManager;

public class DefaultStoredRenditionManager
implements StoredRenditionManager {
    @Override
    public StoredRendition createStoredRendition(DocumentModel liveDocument, DocumentModel versionDocument, Blob renditionBlob, RenditionDefinition renditionDefinition) {
        RenditionCreator rc = new RenditionCreator(liveDocument, versionDocument, renditionBlob, renditionDefinition);
        rc.runUnrestricted();
        DocumentModel storedDoc = rc.getDetachedRendition();
        CoreSession coreSession = liveDocument.getCoreSession();
        return this.toStoredRendition(storedDoc, renditionDefinition, coreSession);
    }

    @Override
    public StoredRendition findStoredRendition(DocumentModel sourceDocument, RenditionDefinition renditionDefinition) {
        RenditionFinder finder = new RenditionFinder(sourceDocument, renditionDefinition);
        finder.runUnrestricted();
        DocumentModel storedDoc = finder.getStoredRendition();
        CoreSession coreSession = sourceDocument.getCoreSession();
        return this.toStoredRendition(storedDoc, renditionDefinition, coreSession);
    }

    protected StoredRendition toStoredRendition(DocumentModel storedDoc, RenditionDefinition def, CoreSession coreSession) {
        if (storedDoc == null) {
            return null;
        }
        storedDoc.attach(coreSession);
        return new StoredRendition(storedDoc, def);
    }
}

