/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProvider;

@XObject(value="renditionDefinitionProvider")
@XRegistry(enable=false)
public class RenditionDefinitionProviderDescriptor {
    private static final Log log = LogFactory.getLog(RenditionDefinitionProviderDescriptor.class);
    @XNode(value="@name")
    @XRegistryId
    protected String name;
    @XNode(value="@enable", fallback="@enabled")
    @XEnable
    protected Boolean enabled;
    @XNode(value="@class")
    protected Class<? extends RenditionDefinitionProvider> providerClass;
    protected RenditionDefinitionProvider provider;
    @XNodeList(value="filters/filter-id", type=ArrayList.class, componentType=String.class)
    protected List<String> filterIds;

    public String getName() {
        return this.name;
    }

    public Class<? extends RenditionDefinitionProvider> getProviderClass() {
        return this.providerClass;
    }

    protected RenditionDefinitionProvider createProvider() {
        if (this.providerClass != null) {
            try {
                return this.providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)String.format("Unable to instantiate RenditionDefinitionProvider for '%s'", this.getName()), (Throwable)e);
            }
        }
        return null;
    }

    public RenditionDefinitionProvider getProvider() {
        if (this.provider != null) {
            return this.provider;
        }
        return this.createProvider();
    }

    public List<String> getFilterIds() {
        return Collections.unmodifiableList(this.filterIds);
    }

    public RenditionDefinitionProvider initProvider() {
        this.provider = this.createProvider();
        return this.provider;
    }
}

