/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProviderDescriptor;
import org.nuxeo.runtime.api.Framework;

public class RenditionDefinitionProviderRegistry
extends MapRegistry {
    public void initialize() {
        super.initialize();
        this.getContributionValues().forEach(RenditionDefinitionProviderDescriptor::initProvider);
    }

    protected ActionContext createActionContext(DocumentModel doc) {
        ELActionContext actionContext = new ELActionContext();
        actionContext.setCurrentDocument(doc);
        CoreSession coreSession = doc.getCoreSession();
        actionContext.setDocumentManager(coreSession);
        if (coreSession != null) {
            actionContext.setCurrentPrincipal(coreSession.getPrincipal());
        }
        return actionContext;
    }

    protected boolean canUseRenditionDefinitionProvider(RenditionDefinitionProviderDescriptor renditionDefinitionProviderDescriptor, DocumentModel doc) {
        ActionManager actionService = (ActionManager)Framework.getService(ActionManager.class);
        return actionService.checkFilters(renditionDefinitionProviderDescriptor.getFilterIds(), this.createActionContext(doc));
    }

    protected Stream<RenditionDefinition> streamRenditionDefinitions(DocumentModel doc) {
        return this.getContributions().values().stream().filter(desc -> this.canUseRenditionDefinitionProvider((RenditionDefinitionProviderDescriptor)desc, doc)).map(RenditionDefinitionProviderDescriptor::getProvider).filter(Objects::nonNull).map(provider -> provider.getRenditionDefinitions(doc)).flatMap(Collection::stream);
    }

    public List<RenditionDefinition> getRenditionDefinitions(DocumentModel doc) {
        return this.streamRenditionDefinitions(doc).collect(Collectors.toList());
    }

    public RenditionDefinition getRenditionDefinition(String name, DocumentModel doc) {
        if (name == null) {
            return null;
        }
        return this.streamRenditionDefinitions(doc).filter(rd -> name.equals(rd.getName())).findFirst().orElse(null);
    }
}

