/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.rendition.extension.DefaultAutomationRenditionProvider;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.runtime.api.Framework;

public class RenditionDefinitionRegistry
extends MapRegistry {
    protected static final RenditionProvider DEFAULT_PROVIDER = new DefaultAutomationRenditionProvider();

    public void initialize() {
        super.initialize();
        this.getContributionValues().forEach(desc -> {
            RenditionProvider p = desc.initProvider();
            if (p == null) {
                desc.setProvider(DEFAULT_PROVIDER);
            }
        });
    }

    protected ActionContext createActionContext(DocumentModel doc) {
        ELActionContext actionContext = new ELActionContext();
        actionContext.setCurrentDocument(doc);
        CoreSession coreSession = doc.getCoreSession();
        actionContext.setDocumentManager(coreSession);
        if (coreSession != null) {
            actionContext.setCurrentPrincipal(coreSession.getPrincipal());
        }
        return actionContext;
    }

    protected boolean canUseRenditionDefinition(RenditionDefinition renditionDefinition, DocumentModel doc) {
        ActionManager actionService = (ActionManager)Framework.getService(ActionManager.class);
        return actionService.checkFilters(renditionDefinition.getFilterIds(), this.createActionContext(doc));
    }

    public RenditionDefinition getRenditionDefinition(String name) {
        if (name == null) {
            return null;
        }
        return this.getContribution(name).or(() -> this.getContributionValues().stream().filter(desc -> name.equals(desc.getCmisName())).findFirst()).orElse(null);
    }

    public List<RenditionDefinition> getRenditionDefinitions(DocumentModel doc) {
        return this.getContributionValues().stream().filter(desc -> this.canUseRenditionDefinition((RenditionDefinition)desc, doc) && desc.getProvider().isAvailable(doc, desc)).collect(Collectors.toList());
    }
}

