/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.http.readonly.service;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.elasticsearch.http.readonly.filter.SearchRequestFilter;
import org.nuxeo.elasticsearch.http.readonly.service.RequestFilterDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class RequestFilterService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("service", "org.nuxeo.elasticsearch.http.readonly.RequestFilterService");
    protected static final String FILTER_EXT_POINT = "filters";
    protected Map<String, Class<? extends SearchRequestFilter>> requestFilters;

    public void start(ComponentContext context) {
        this.requestFilters = this.getRegistryContributions(FILTER_EXT_POINT).stream().collect(Collectors.toConcurrentMap(RequestFilterDescriptor::getIndex, RequestFilterDescriptor::getFilterClass));
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.requestFilters = null;
    }

    public Map<String, Class<? extends SearchRequestFilter>> getRequestFilters() {
        return Collections.unmodifiableMap(this.requestFilters);
    }

    public SearchRequestFilter getRequestFilters(String indices) throws ReflectiveOperationException {
        Class<? extends SearchRequestFilter> clazz = this.requestFilters.get(indices);
        if (clazz == null) {
            return null;
        }
        return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

