/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class RepositoryManagerImpl
extends DefaultComponent
implements RepositoryManager {
    private static final Log log = LogFactory.getLog(RepositoryManagerImpl.class);
    private Map<String, Repository> repositories;

    public int getApplicationStartedOrder() {
        return -100;
    }

    public void start(ComponentContext context) {
        this.repositories = Collections.synchronizedMap(new LinkedHashMap());
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.repositories = null;
    }

    @Override
    public void addRepository(Repository repository) {
        String name = repository.getName();
        if (this.repositories.containsKey(name)) {
            log.info((Object)("Overriding repository: " + name));
        } else {
            log.info((Object)("Registering repository: " + name));
        }
        this.repositories.put(name, repository);
    }

    @Override
    public void removeRepository(String name) {
        log.info((Object)("Removing repository: " + name));
        this.repositories.remove(name);
    }

    @Override
    public Collection<Repository> getRepositories() {
        return new ArrayList<Repository>(this.repositories.values());
    }

    @Override
    public List<String> getRepositoryNames() {
        return new ArrayList<String>(this.repositories.keySet());
    }

    @Override
    public Repository getRepository(String name) {
        return this.repositories.get(name);
    }

    @Override
    public Repository getDefaultRepository() {
        for (Repository repository : this.repositories.values()) {
            if (repository.isDefault()) {
                return repository;
            }
            if (!"default".equals(repository.getName())) continue;
            return repository;
        }
        if (!this.repositories.isEmpty()) {
            return this.repositories.values().iterator().next();
        }
        throw new RuntimeException("No repository defined");
    }

    @Override
    public String getDefaultRepositoryName() {
        return this.getDefaultRepository().getName();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (RepositoryManager.class.isAssignableFrom(adapter)) {
            return (T)this;
        }
        return null;
    }
}

