/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.thumbnail;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailFactory;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class ThumbnailServiceImpl
extends DefaultComponent
implements ThumbnailService {
    public static final String THUMBNAILFACTORY_EP = "thumbnailFactory";
    protected ThumbnailFactory defaultFactory;
    protected Map<String, ThumbnailFactory> factoriesByDocType;
    protected Map<String, ThumbnailFactory> factoriesByFacets;

    public void start(ComponentContext context) {
        this.factoriesByDocType = new HashMap<String, ThumbnailFactory>();
        this.factoriesByFacets = new HashMap<String, ThumbnailFactory>();
        this.getRegistryContributions(THUMBNAILFACTORY_EP).forEach(desc -> {
            String facet;
            ThumbnailFactory factory = desc.getFactory();
            String docType = desc.getDocType();
            if (docType != null) {
                this.factoriesByDocType.put(docType, factory);
            }
            if ((facet = desc.getFacet()) != null) {
                this.factoriesByFacets.put(facet, factory);
            }
            if (docType == null && facet == null) {
                this.defaultFactory = factory;
            }
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.defaultFactory = null;
        this.factoriesByDocType = null;
        this.factoriesByFacets = null;
    }

    public Set<String> getFactoryByDocTypeNames() {
        return this.factoriesByDocType.keySet();
    }

    public Set<String> getFactoryByFacetNames() {
        return this.factoriesByFacets.keySet();
    }

    public ThumbnailFactory getDefaultFactory() {
        return this.defaultFactory;
    }

    @Override
    public Blob getThumbnail(DocumentModel doc, CoreSession session) {
        ThumbnailFactory factory = this.getThumbnailFactory(doc, session);
        return factory.getThumbnail(doc, session);
    }

    @Override
    public Blob computeThumbnail(DocumentModel doc, CoreSession session) {
        ThumbnailFactory factory = this.getThumbnailFactory(doc, session);
        return factory.computeThumbnail(doc, session);
    }

    public ThumbnailFactory getThumbnailFactory(DocumentModel doc, CoreSession session) {
        if (this.factoriesByDocType.containsKey(doc.getType())) {
            ThumbnailFactory factory = this.factoriesByDocType.get(doc.getType());
            return factory;
        }
        for (Map.Entry<String, ThumbnailFactory> entry : this.factoriesByFacets.entrySet()) {
            if (!doc.hasFacet(entry.getKey())) continue;
            return entry.getValue();
        }
        if (this.defaultFactory == null) {
            throw new NuxeoException("Please contribute a default thumbnail factory");
        }
        return this.defaultFactory;
    }
}

