/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.AbstractBlobProvider;
import org.nuxeo.ecm.core.blob.AbstractBlobStore;
import org.nuxeo.ecm.core.blob.BlobContext;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobUpdateContext;
import org.nuxeo.ecm.core.blob.ByteRange;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.KeyStrategyDigest;
import org.nuxeo.ecm.core.blob.KeyStrategyDocId;
import org.nuxeo.ecm.core.blob.KeyStrategyManaged;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.runtime.api.Framework;

public abstract class BlobStoreBlobProvider
extends AbstractBlobProvider {
    public static final String KEY_STRATEGY_PROPERTY = "keyStrategy";
    public static final String MANAGED_KEY_STRATEGY = "managed";
    public static final String DIGEST_KEY_STRATEGY = "digest";
    public BlobStore store;

    @Override
    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        super.initialize(blobProviderId, properties);
        this.store = this.getBlobStore(blobProviderId, properties);
    }

    protected abstract BlobStore getBlobStore(String var1, Map<String, String> var2) throws IOException;

    public KeyStrategy getKeyStrategy() {
        KeyStrategy keyStrategy;
        boolean hasDigest;
        boolean bl = hasDigest = this.properties.get(DIGEST_KEY_STRATEGY) != null;
        if (this.isRecordMode() && !hasDigest) {
            keyStrategy = KeyStrategyDocId.instance();
        } else {
            String strKeyStrategy = this.properties.getOrDefault(KEY_STRATEGY_PROPERTY, DIGEST_KEY_STRATEGY);
            keyStrategy = new KeyStrategyDigest(this.getDigestAlgorithm());
            if (MANAGED_KEY_STRATEGY.equals(strKeyStrategy)) {
                keyStrategy = new KeyStrategyManaged(keyStrategy);
            }
        }
        return keyStrategy;
    }

    protected abstract String getDigestAlgorithm();

    @Override
    public BinaryManager getBinaryManager() {
        return null;
    }

    @Override
    public boolean supportsSync() {
        return this.supportsUserUpdate();
    }

    @Override
    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.store.getBinaryGarbageCollector();
    }

    protected String stripBlobKeyPrefix(String key) {
        int colon = key.indexOf(58);
        if (colon >= 0 && key.substring(0, colon).equals(this.blobProviderId)) {
            key = key.substring(colon + 1);
        }
        return key;
    }

    protected String stripBlobKeyVersionSuffix(String key) {
        int seppos = key.indexOf(64);
        if (seppos >= 0) {
            key = key.substring(0, seppos);
        }
        return key;
    }

    @Override
    public String writeBlob(BlobContext blobContext) throws IOException {
        String key = this.store.writeBlob(blobContext);
        this.fixupDigest(blobContext.blob, key);
        return key;
    }

    @Override
    public String writeBlob(Blob blob) throws IOException {
        if (this.isRecordMode()) {
            throw new UnsupportedOperationException("Cannot write blob directly without context in record mode");
        }
        return this.writeBlob(new BlobContext(blob));
    }

    @Override
    public InputStream getStream(ManagedBlob blob) throws IOException {
        String blobKey = blob.getKey();
        return this.getStream(blobKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getStream(String blobKey, ByteRange byteRange) throws IOException {
        BlobStore.OptionalOrUnknown<InputStream> streamOpt;
        String key = this.stripBlobKeyPrefix(blobKey);
        if (byteRange != null) {
            if (!this.allowByteRange()) {
                throw new UnsupportedOperationException("Cannot use byte ranges in keys");
            }
            key = AbstractBlobStore.setByteRangeInKey(key, byteRange);
        }
        if ((streamOpt = this.store.getStream(key)).isKnown()) {
            if (!streamOpt.isPresent()) {
                throw new IOException("Missing blob: " + key);
            }
            return streamOpt.get();
        }
        boolean returned = false;
        Path tmp = Framework.createTempFilePath((String)"bin_", (String)".tmp", (FileAttribute[])new FileAttribute[0]);
        try {
            boolean found = this.store.readBlob(key, tmp);
            if (!found) {
                throw new IOException("Missing blob: " + key);
            }
            AutoDeleteFileInputStream stream = new AutoDeleteFileInputStream(tmp);
            returned = true;
            AutoDeleteFileInputStream autoDeleteFileInputStream = stream;
            return autoDeleteFileInputStream;
        }
        finally {
            if (!returned) {
                Files.deleteIfExists(tmp);
            }
        }
    }

    @Override
    public File getFile(ManagedBlob blob) {
        String key = this.stripBlobKeyPrefix(blob.getKey());
        BlobStore.OptionalOrUnknown<Path> fileOpt = this.store.getFile(key);
        return fileOpt.isPresent() ? fileOpt.get().toFile() : null;
    }

    @Override
    public Blob readBlob(BlobInfo blobInfo) throws IOException {
        SimpleManagedBlob blob = new SimpleManagedBlob(this.blobProviderId, blobInfo);
        this.fixupDigest(blob, blob.getKey());
        return blob;
    }

    protected void fixupDigest(Blob blob, String key) {
        if (blob.getDigestAlgorithm() == null) {
            KeyStrategy keyStrategy = this.store.getKeyStrategy();
            if (keyStrategy instanceof KeyStrategyManaged) {
                keyStrategy = ((KeyStrategyManaged)keyStrategy).strategy;
            }
            if (keyStrategy instanceof KeyStrategyDigest) {
                KeyStrategyDigest ksd = (KeyStrategyDigest)keyStrategy;
                String currentDigest = blob.getDigest();
                if (currentDigest == null || currentDigest.contains("-")) {
                    String digest = this.stripBlobKeyVersionSuffix(this.stripBlobKeyPrefix(key));
                    blob.setDigest(digest);
                    currentDigest = digest;
                }
                if (blob.getDigestAlgorithm() == null && ksd.isValidDigest(currentDigest)) {
                    blob.setDigestAlgorithm(ksd.digestAlgorithm);
                }
            }
        }
    }

    @Override
    public void updateBlob(BlobUpdateContext blobUpdateContext) throws IOException {
        this.store.writeBlobProperties(blobUpdateContext);
    }

    @Override
    public void deleteBlob(BlobContext blobContext) {
        this.store.deleteBlob(blobContext);
    }

    public static class AutoDeleteFileInputStream
    extends FileInputStream {
        private static final Logger log = LogManager.getLogger(AutoDeleteFileInputStream.class);
        protected Path file;

        public AutoDeleteFileInputStream(Path file) throws IOException {
            super(file.toFile());
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                if (this.file != null) {
                    try {
                        Files.deleteIfExists(this.file);
                    }
                    catch (IOException e) {
                        log.warn((Object)e, (Throwable)e);
                    }
                    this.file = null;
                }
            }
        }
    }
}

