/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.nuxeo.ecm.core.blob.PropertyBasedConfiguration;

public class DigestConfiguration
extends PropertyBasedConfiguration {
    public static final String DIGEST_ALGORITHM_PROPERTY = "digest";
    public static final String DIGEST_ASYNC_PROPERTY = "digestAsync";
    public static final String DEFAULT_DIGEST_ALGORITHM = "MD5";
    public final String digestAlgorithm;
    @Deprecated
    public final Pattern digestPattern;
    public final boolean digestAsync;

    public DigestConfiguration(String digestAlgorithm) {
        super(null, null);
        this.digestAlgorithm = digestAlgorithm;
        this.digestPattern = this.getDigestPattern();
        this.digestAsync = false;
    }

    public DigestConfiguration(String systemPropertyPrefix, Map<String, String> properties) {
        super(systemPropertyPrefix, properties);
        this.digestAlgorithm = this.getDigestAlgorithm();
        this.digestPattern = this.getDigestPattern();
        this.digestAsync = this.getBooleanProperty(DIGEST_ASYNC_PROPERTY);
    }

    protected String getDigestAlgorithm() {
        return this.getProperty(DIGEST_ALGORITHM_PROPERTY, DEFAULT_DIGEST_ALGORITHM).toUpperCase(Locale.ENGLISH);
    }

    @Deprecated
    protected Pattern getDigestPattern() {
        int len = new DigestUtils(this.digestAlgorithm).digestAsHex(new byte[0]).length();
        return Pattern.compile("[0-9a-f]{" + len + "}");
    }

    @Deprecated
    public boolean isValidDigest(String digest) {
        return this.digestPattern.matcher(digest).matches();
    }
}

