/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.nuxeo.ecm.core.blob.AbstractBlobGarbageCollector;
import org.nuxeo.ecm.core.blob.AbstractBlobStore;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;

public class EmptyBlobStore
extends AbstractBlobStore {
    protected final EmptyBlobGarbageCollector gc = new EmptyBlobGarbageCollector();

    public EmptyBlobStore(String blobProviderId, String name, KeyStrategy keyStrategy) {
        super(blobProviderId, name, keyStrategy);
    }

    @Override
    protected String writeBlobGeneric(BlobWriteContext blobWriteContext) throws IOException {
        String key = blobWriteContext.getKey();
        return key == null ? this.randomString() : key;
    }

    @Override
    public boolean copyBlobIsOptimized(BlobStore sourceStore) {
        return false;
    }

    @Override
    public String copyOrMoveBlob(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        if (atomicMove) {
            sourceStore.deleteBlob(sourceKey);
        }
        return key;
    }

    @Override
    public BlobStore.OptionalOrUnknown<Path> getFile(String key) {
        return BlobStore.OptionalOrUnknown.missing();
    }

    @Override
    public BlobStore.OptionalOrUnknown<InputStream> getStream(String key) throws IOException {
        return BlobStore.OptionalOrUnknown.missing();
    }

    @Override
    public boolean readBlob(String key, Path dest) throws IOException {
        return false;
    }

    @Override
    public void deleteBlob(String key) {
    }

    @Override
    public void clear() {
    }

    @Override
    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.gc;
    }

    public class EmptyBlobGarbageCollector
    extends AbstractBlobGarbageCollector {
        @Override
        public String getId() {
            return this.toString();
        }

        @Override
        public void removeUnmarkedBlobsAndUpdateStatus(boolean delete) {
        }
    }
}

