/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XMerge;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.platform.types.DocumentContentViews;
import org.nuxeo.ecm.platform.types.Layouts;
import org.nuxeo.ecm.platform.types.SubType;
import org.nuxeo.ecm.platform.types.TypeView;

@XObject(value="type")
@XRegistry
public class Type {
    public static final String[] EMPTY_ACTIONS = new String[0];
    @XNode(value="@id")
    @XRegistryId
    protected String id;
    @XNode(value="icon")
    protected String icon;
    @XNode(value="icon-expanded")
    protected String iconExpanded;
    @XNode(value="bigIcon")
    protected String bigIcon;
    @XNode(value="bigIcon-expanded")
    protected String bigIconExpanded;
    @XNode(value="label")
    protected String label;
    @XNodeList(value="subtypes/type", type=ArrayList.class, componentType=SubType.class)
    @XMerge(defaultAssignment=false)
    protected List<SubType> allowedSubTypes = new ArrayList<SubType>();
    @XNodeList(value="deniedSubtypes/type", type=String[].class, componentType=String.class)
    @XMerge(defaultAssignment=false)
    protected String[] deniedSubTypes;
    @XNode(value="default-view")
    protected String defaultView;
    @XNode(value="create-view")
    protected String createView;
    @XNode(value="edit-view")
    protected String editView;
    @XNode(value="description")
    protected String description;
    @XNode(value="category")
    protected String category;
    @XNodeMap(value="views/view", key="@id", type=HashMap.class, componentType=TypeView.class)
    protected Map<String, TypeView> views;
    @XNodeList(value="actions/action", type=String[].class, componentType=String.class)
    @XMerge(defaultAssignment=false)
    protected String[] actions;
    @XNodeMap(value="layouts", key="@mode", type=HashMap.class, componentType=Layouts.class)
    @XMerge(value="layouts@append", defaultAssignment=false)
    protected Map<String, Layouts> layouts;
    @XNodeMap(value="contentViews", key="@category", type=HashMap.class, componentType=DocumentContentViews.class)
    @XMerge(value="contentViews@append", defaultAssignment=false)
    protected Map<String, DocumentContentViews> contentViews;

    public Type() {
    }

    public Type(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public String[] getActions() {
        return this.actions;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getBigIcon() {
        return this.bigIcon;
    }

    public String getBigIconExpanded() {
        return this.bigIconExpanded;
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public String[] getLayouts(String mode) {
        return this.getLayouts(mode, "any");
    }

    public String[] getLayouts(String mode, String defaultMode) {
        Layouts modeLayouts = this.layouts.get(mode);
        if (modeLayouts == null && defaultMode != null) {
            modeLayouts = this.layouts.get(defaultMode);
        }
        if (modeLayouts != null) {
            return modeLayouts.getLayouts();
        }
        return new String[0];
    }

    public Map<String, Layouts> getLayouts() {
        return Collections.unmodifiableMap(this.layouts);
    }

    public String getDefaultView() {
        return this.defaultView;
    }

    public String getCreateView() {
        return this.createView;
    }

    public String getEditView() {
        return this.editView;
    }

    public TypeView[] getViews() {
        return this.views.values().toArray(new TypeView[this.views.size()]);
    }

    public TypeView getView(String viewId) {
        return this.views.get(viewId);
    }

    public String[] getDeniedSubTypes() {
        return this.deniedSubTypes;
    }

    public void setDeniedSubTypes(String[] deniedSubTypes) {
        this.deniedSubTypes = deniedSubTypes;
    }

    public Map<String, SubType> getAllowedSubTypes() {
        HashMap<String, SubType> map = new HashMap<String, SubType>();
        for (SubType type : this.allowedSubTypes) {
            String name = type.getName();
            SubType previousType = (SubType)map.get(name);
            if (previousType == null) {
                map.put(name, type);
                continue;
            }
            HashSet<String> hiddenMerged = new HashSet<String>();
            hiddenMerged.addAll(previousType.getHidden());
            hiddenMerged.addAll(type.getHidden());
            map.put(name, new SubType(name, hiddenMerged));
        }
        return map;
    }

    public void setAllowedSubTypes(Map<String, SubType> allowedSubTypes) {
        this.allowedSubTypes = new ArrayList<SubType>(allowedSubTypes.values());
    }

    public String getIconExpanded() {
        return this.iconExpanded;
    }

    public String[] getContentViews(String category) {
        DocumentContentViews cv;
        if (this.contentViews != null && (cv = this.contentViews.get(category)) != null) {
            return cv.getContentViewNames();
        }
        return new String[0];
    }

    public Map<String, DocumentContentViews> getContentViews() {
        return Collections.unmodifiableMap(this.contentViews);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Type.class.getSimpleName());
        sb.append(" {");
        sb.append("id: ");
        sb.append(this.id);
        sb.append('}');
        return sb.toString();
    }
}

