/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.nxql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageSelections;
import org.nuxeo.ecm.platform.query.api.QuickFilter;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryAndFetchUnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryDocumentPageProvider;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;

public class CoreQueryAndFetchPageProvider
extends AbstractPageProvider<Map<String, Serializable>> {
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String CHECK_QUERY_CACHE_PROPERTY = "checkQueryCache";
    public static final String USE_UNRESTRICTED_SESSION_PROPERTY = "useUnrestrictedSession";
    public static final String LANGUAGE_PROPERTY = "language";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CoreQueryDocumentPageProvider.class);
    protected String query;
    protected List<Map<String, Serializable>> currentItems;

    protected CoreSession getCoreSession() {
        Map<String, Serializable> props = this.getProperties();
        CoreSession coreSession = (CoreSession)props.get(CORE_SESSION_PROPERTY);
        return coreSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Serializable>> getCurrentPage() {
        this.checkQueryCache();
        CoreSession coreSession = null;
        long t0 = System.currentTimeMillis();
        if (this.currentItems == null) {
            this.errorMessage = null;
            this.error = null;
            if (this.query == null) {
                this.buildQuery();
            }
            if (this.query == null) {
                throw new NuxeoException(String.format("Cannot perform null query: check provider '%s'", this.getName()));
            }
            this.currentItems = new ArrayList<Map<String, Serializable>>();
            coreSession = this.getCoreSession();
            if (coreSession == null) {
                throw new NuxeoException("cannot find core session");
            }
            try (IterableQueryResult result = null;){
                long minMaxPageSize = this.getMinMaxPageSize();
                long offset = this.getCurrentPageOffset();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Perform query for provider '%s': '%s' with pageSize=%s, offset=%s", this.getName(), this.query, minMaxPageSize, offset));
                }
                String language = this.getQueryLanguage();
                boolean useUnrestricted = this.useUnrestrictedSession();
                if (useUnrestricted) {
                    CoreQueryAndFetchUnrestrictedSessionRunner r = new CoreQueryAndFetchUnrestrictedSessionRunner(coreSession, this.query, language);
                    r.runUnrestricted();
                    result = r.getResult();
                } else {
                    result = coreSession.queryAndFetch(this.query, language, new Object[0]);
                }
                long resultsCount = result.size();
                this.setResultsCount(resultsCount);
                if (offset < resultsCount) {
                    result.skipTo(offset);
                }
                Iterator it = result.iterator();
                int pos = 0;
                while (it.hasNext() && (this.maxPageSize == 0L || (long)pos < minMaxPageSize)) {
                    ++pos;
                    Map item = (Map)it.next();
                    this.currentItems.add(item);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Performed query for provider '%s': got %s hits", this.getName(), resultsCount));
                }
            }
        }
        if (coreSession == null) {
            coreSession = this.getCoreSession();
        }
        this.fireSearchEvent(coreSession.getPrincipal(), this.query, this.currentItems, System.currentTimeMillis() - t0);
        return this.currentItems;
    }

    protected void buildQuery() {
        String newQuery;
        ArrayList sort = new ArrayList();
        List<QuickFilter> quickFilters = this.getQuickFilters();
        String quickFiltersClause = "";
        if (quickFilters != null && !quickFilters.isEmpty()) {
            for (QuickFilter quickFilter : quickFilters) {
                String clause = quickFilter.getClause();
                quickFiltersClause = !quickFiltersClause.isEmpty() && clause != null ? NXQLQueryBuilder.appendClause(quickFiltersClause, clause) : (clause != null ? clause : "");
                sort.addAll(quickFilter.getSortInfos());
            }
        }
        if (this.sortInfos != null) {
            sort.addAll(this.sortInfos);
        }
        SortInfo[] sortArray = (SortInfo[])sort.toArray(SortInfo[]::new);
        PageProviderDefinition def = this.getDefinition();
        WhereClauseDefinition whereClause = def.getWhereClause();
        if (whereClause == null) {
            String originalPattern = def.getPattern();
            String pattern = quickFiltersClause.isEmpty() ? originalPattern : (StringUtils.containsIgnoreCase((CharSequence)originalPattern, (CharSequence)" WHERE ") ? NXQLQueryBuilder.appendClause(originalPattern, quickFiltersClause) : originalPattern + " WHERE " + quickFiltersClause);
            newQuery = NXQLQueryBuilder.getQuery(pattern, this.getParameters(), def.getQuotePatternParameters(), def.getEscapePatternParameters(), this.getSearchDocumentModel(), sortArray);
        } else {
            DocumentModel searchDocumentModel = this.getSearchDocumentModel();
            if (searchDocumentModel == null) {
                throw new NuxeoException(String.format("Cannot build query of provider '%s': no search document model is set", this.getName()));
            }
            newQuery = NXQLQueryBuilder.getQuery(searchDocumentModel, whereClause, quickFiltersClause, this.getParameters(), sortArray);
        }
        if (this.query != null && newQuery != null && !newQuery.equals(this.query)) {
            this.refresh();
        }
        this.query = newQuery;
    }

    @Override
    public PageSelections<Map<String, Serializable>> getCurrentSelectPage() {
        this.checkQueryCache();
        this.rewindSelectablePage();
        return super.getCurrentSelectPage();
    }

    protected void rewindSelectablePage() {
        long pageSize = this.getPageSize();
        if (pageSize != 0L && this.offset != 0L && this.currentItems != null && this.currentItems.size() == 0) {
            if (this.resultsCount == 0L) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Current page %s is not the first one but shows no result and there are no results => rewind to first page", this.getCurrentPageIndex()));
                }
                this.firstPage();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Current page %s is not the first one but shows no result and there are %s results => fetch last page", this.getCurrentPageIndex(), this.resultsCount));
                }
                this.lastPage();
            }
            this.getCurrentPage();
        }
    }

    protected void checkQueryCache() {
        if (this.getBooleanProperty(CHECK_QUERY_CACHE_PROPERTY, false)) {
            this.buildQuery();
        }
    }

    protected boolean useUnrestrictedSession() {
        return this.getBooleanProperty(USE_UNRESTRICTED_SESSION_PROPERTY, false);
    }

    protected String getQueryLanguage() {
        Map<String, Serializable> props = this.getProperties();
        if (props.containsKey(LANGUAGE_PROPERTY)) {
            return (String)((Object)props.get(LANGUAGE_PROPERTY));
        }
        return "NXQL";
    }

    public String getCurrentQuery() {
        return this.query;
    }

    @Override
    protected void pageChanged() {
        this.currentItems = null;
        super.pageChanged();
    }

    @Override
    public void refresh() {
        this.query = null;
        this.currentItems = null;
        super.refresh();
    }
}

