/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.platform.video.VideoHelper;

public class VideoStoryboardWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(VideoStoryboardWork.class);
    public static final String CATEGORY_VIDEO_STORYBOARD = "videoStoryboard";

    protected static String computeIdPrefix(String repositoryName, String docId) {
        return repositoryName + ":" + docId + ":videostoryboard:";
    }

    public VideoStoryboardWork(String repositoryName, String docId) {
        super(VideoStoryboardWork.computeIdPrefix(repositoryName, docId));
        this.setDocument(repositoryName, docId);
    }

    public boolean isIdempotent() {
        return false;
    }

    public String getCategory() {
        return CATEGORY_VIDEO_STORYBOARD;
    }

    public String getTitle() {
        return "Video Storyboard: " + this.getId();
    }

    public void work() {
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.openSystemSession();
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        Blob video = blobHolder.getBlob();
        this.setStatus("Updating storyboard");
        boolean save = this.updateStoryboard(doc, video);
        this.setStatus("Updating previews");
        if (save |= this.updatePreviews(doc, video)) {
            if (doc.isVersion()) {
                doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
            }
            this.session.saveDocument(doc);
        }
        this.setStatus("Done");
    }

    protected boolean updateStoryboard(DocumentModel doc, Blob blob) {
        List storyboard = (List)((Object)doc.getPropertyValue("vid:storyboard"));
        if (storyboard != null && !storyboard.isEmpty()) {
            return false;
        }
        log.debug((Object)String.format("Updating storyboard of Video document %s.", doc));
        VideoHelper.updateStoryboard(doc, blob);
        log.debug((Object)String.format("End updating storyboard of Video document %s.", doc));
        return true;
    }

    protected boolean updatePreviews(DocumentModel doc, Blob blob) {
        List previews = (List)((Object)doc.getPropertyValue("picture:views"));
        if (previews != null && !previews.isEmpty()) {
            return false;
        }
        log.debug((Object)String.format("Updating previews of Video document %s.", doc));
        try {
            VideoHelper.updatePreviews(doc, blob);
            log.debug((Object)String.format("End updating previews of Video document %s.", doc));
            return true;
        }
        catch (IOException e) {
            log.debug((Object)String.format("Failed to extract previews of Video document %s.", doc), (Throwable)e);
            return false;
        }
    }
}

