/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.StreamRef;
import org.nuxeo.runtime.model.URLStreamRef;
import org.nuxeo.runtime.model.impl.ComponentDescriptorReader;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.osgi.OSGiRuntimeActivator;
import org.nuxeo.runtime.osgi.OSGiRuntimeContext;
import org.osgi.framework.Bundle;

public class DefaultRuntimeContext
implements RuntimeContext {
    private static final Logger log = LogManager.getLogger(DefaultRuntimeContext.class);
    protected RuntimeService runtime;
    protected List<ComponentName> components;
    protected final ComponentDescriptorReader reader;

    public DefaultRuntimeContext() {
        this(Framework.getRuntime());
    }

    public DefaultRuntimeContext(RuntimeService runtime) {
        this.runtime = runtime;
        this.components = new ArrayList<ComponentName>();
        this.reader = new ComponentDescriptorReader();
    }

    public void setRuntime(RuntimeService runtime) {
        this.runtime = runtime;
    }

    @Override
    public RuntimeService getRuntime() {
        return this.runtime;
    }

    @Override
    public ComponentName[] getComponents() {
        return this.components.toArray(new ComponentName[0]);
    }

    @Override
    public URL getResource(String name) {
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    @Override
    public URL getLocalResource(String name) {
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    @Override
    public RegistrationInfo deploy(URL url) throws IOException {
        return this.deploy(new URLStreamRef(url));
    }

    @Override
    public RegistrationInfo deploy(StreamRef ref) throws IOException {
        Bundle bundle;
        String name = ref.getId();
        RegistrationInfoImpl ri = this.createRegistrationInfo(ref);
        log.debug("Deploying component from url {}", (Object)name);
        ri.sourceId = name;
        ri.context = this;
        ri.xmlFileUrl = ref.asURL();
        if (ri.getBundle() != null && (bundle = OSGiRuntimeActivator.getInstance().getBundle(ri.getBundle())) != null) {
            ri.context = new OSGiRuntimeContext(bundle);
        }
        this.runtime.getComponentManager().register(ri);
        this.components.add(ri.getName());
        return ri;
    }

    @Override
    public void undeploy(URL url) {
        this.runtime.getComponentManager().unregisterByLocation(url.toString());
    }

    @Override
    public void undeploy(StreamRef ref) {
        this.runtime.getComponentManager().unregisterByLocation(ref.getId());
    }

    @Override
    public boolean isDeployed(URL url) {
        return this.runtime.getComponentManager().hasComponentFromLocation(url.toString());
    }

    @Override
    public boolean isDeployed(StreamRef ref) {
        return this.runtime.getComponentManager().hasComponentFromLocation(ref.getId());
    }

    @Override
    public RegistrationInfo deploy(String location) {
        URL url = this.getLocalResource(location);
        if (url == null) {
            throw new IllegalArgumentException("No local resources was found with this name: " + location);
        }
        try {
            return this.deploy(url);
        }
        catch (IOException e) {
            throw new RuntimeServiceException("Cannot deploy: " + location, e);
        }
    }

    @Override
    public void undeploy(String location) {
        URL url = this.getLocalResource(location);
        if (url == null) {
            throw new IllegalArgumentException("No local resources was found with this name: " + location);
        }
        this.undeploy(url);
    }

    @Override
    public boolean isDeployed(String location) {
        URL url = this.getLocalResource(location);
        if (url != null) {
            return this.isDeployed(url);
        }
        log.warn("No local resources was found with this name: {}", (Object)location);
        return false;
    }

    @Override
    public void destroy() {
        ComponentManager mgr = this.runtime.getComponentManager();
        for (ComponentName cname : this.components) {
            mgr.unregister(cname);
        }
    }

    @Override
    public Bundle getBundle() {
        return null;
    }

    public RegistrationInfoImpl createRegistrationInfo(StreamRef ref) throws IOException {
        RegistrationInfoImpl ri;
        String source;
        try (InputStream stream = ref.getStream();){
            source = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        }
        if (StringUtils.isBlank((CharSequence)source)) {
            throw new IOException("Empty registration from " + ref.getId());
        }
        String expanded = Framework.expandVars(source);
        try (ByteArrayInputStream in = new ByteArrayInputStream(expanded.getBytes());){
            ri = this.createRegistrationInfo(in);
        }
        catch (IOException e) {
            throw new IOException(String.format("Could not resolve registration from %s (%s)", ref.getId(), e.getMessage()), e);
        }
        if (ri == null || ri.getName() == null) {
            throw new IOException("Could not resolve registration from " + ref.getId());
        }
        return ri;
    }

    public RegistrationInfoImpl createRegistrationInfo(InputStream in) throws IOException {
        return this.reader.read(this, in);
    }
}

