/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.jvm;

import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.MetricSet;
import io.dropwizard.metrics5.jvm.ThreadDeadlockDetector;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ThreadStatesGaugeSet
implements MetricSet {
    private static final int STACK_TRACE_DEPTH = 0;
    private final ThreadMXBean threads;
    private final ThreadDeadlockDetector deadlockDetector;

    public ThreadStatesGaugeSet() {
        this(ManagementFactory.getThreadMXBean(), new ThreadDeadlockDetector());
    }

    public ThreadStatesGaugeSet(ThreadMXBean threads, ThreadDeadlockDetector deadlockDetector) {
        this.threads = threads;
        this.deadlockDetector = deadlockDetector;
    }

    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, Gauge> gauges = new HashMap<MetricName, Gauge>();
        for (Thread.State state : Thread.State.values()) {
            gauges.put(MetricRegistry.name((String)state.toString().toLowerCase(), (String[])new String[]{"count"}), () -> this.getThreadCount(state));
        }
        gauges.put(MetricName.build((String[])new String[]{"count"}), this.threads::getThreadCount);
        gauges.put(MetricName.build((String[])new String[]{"daemon.count"}), this.threads::getDaemonThreadCount);
        gauges.put(MetricName.build((String[])new String[]{"peak.count"}), this.threads::getPeakThreadCount);
        gauges.put(MetricName.build((String[])new String[]{"total_started.count"}), this.threads::getTotalStartedThreadCount);
        gauges.put(MetricName.build((String[])new String[]{"deadlock.count"}), () -> this.deadlockDetector.getDeadlockedThreads().size());
        gauges.put(MetricName.build((String[])new String[]{"deadlocks"}), this.deadlockDetector::getDeadlockedThreads);
        return Collections.unmodifiableMap(gauges);
    }

    private int getThreadCount(Thread.State state) {
        ThreadInfo[] allThreads = this.getThreadInfo();
        int count = 0;
        for (ThreadInfo info : allThreads) {
            if (info == null || info.getThreadState() != state) continue;
            ++count;
        }
        return count;
    }

    ThreadInfo[] getThreadInfo() {
        return this.threads.getThreadInfo(this.threads.getAllThreadIds(), 0);
    }
}

