/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.mongodb;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;

public class MongoDBSerializationHelper {
    public static final String MONGODB_ID = "_id";

    private MongoDBSerializationHelper() {
    }

    public static Document fieldMapToBson(String key, Object value) {
        return MongoDBSerializationHelper.fieldMapToBson(Collections.singletonMap(key, value));
    }

    public static Document fieldMapToBson(Map<String, Object> fieldMap) {
        Document doc = new Document();
        for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
            Object val = MongoDBSerializationHelper.valueToBson(entry.getValue());
            if (val == null) continue;
            doc.put(entry.getKey(), val);
        }
        return doc;
    }

    public static Object valueToBson(Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return MongoDBSerializationHelper.fieldMapToBson(map);
        }
        if (value instanceof List) {
            List values = (List)value;
            return MongoDBSerializationHelper.listToBson(values);
        }
        if (value instanceof Object[]) {
            return MongoDBSerializationHelper.listToBson(Arrays.asList((Object[])value));
        }
        return MongoDBSerializationHelper.serializableToBson(value);
    }

    protected static List<Object> listToBson(List<Object> values) {
        ArrayList<Object> objects = new ArrayList<Object>(values.size());
        for (Object value : values) {
            objects.add(MongoDBSerializationHelper.valueToBson(value));
        }
        return objects;
    }

    protected static Object serializableToBson(Object value) {
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        return value;
    }

    public static Map<String, Object> bsonToFieldMap(Document doc) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        for (String key : doc.keySet()) {
            if (MONGODB_ID.equals(key)) continue;
            fieldMap.put(key, MongoDBSerializationHelper.bsonToValue(doc.get((Object)key)));
        }
        return fieldMap;
    }

    protected static Serializable bsonToValue(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return null;
            }
            Class klass = Object.class;
            for (Object o : list) {
                if (o == null) continue;
                klass = MongoDBSerializationHelper.scalarToSerializableClass(o.getClass());
                break;
            }
            if (Document.class.isAssignableFrom(klass)) {
                ArrayList<Serializable> l = new ArrayList<Serializable>(list.size());
                for (Object o : list) {
                    l.add((Serializable)((Object)MongoDBSerializationHelper.bsonToFieldMap((Document)o)));
                }
                return l;
            }
            Object[] array = (Object[])Array.newInstance(klass, list.size());
            int i = 0;
            for (Object o : list) {
                array[i++] = MongoDBSerializationHelper.scalarToSerializable(o);
            }
            return array;
        }
        if (value instanceof Document) {
            return (Serializable)((Object)MongoDBSerializationHelper.bsonToFieldMap((Document)value));
        }
        return MongoDBSerializationHelper.scalarToSerializable(value);
    }

    protected static Class<?> scalarToSerializableClass(Class<?> klass) {
        if (Date.class.isAssignableFrom(klass)) {
            return Calendar.class;
        }
        return klass;
    }

    protected static Serializable scalarToSerializable(Object value) {
        if (value instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)value);
            return cal;
        }
        return (Serializable)value;
    }
}

