/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.service;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLink;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginStartupPage;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginVideo;
import org.nuxeo.runtime.api.Framework;

@XObject(value="loginScreenConfig")
@XRegistry
public class LoginScreenConfig {
    public static final String NUXEO_NEWS_URL = "//www.nuxeo.com/login-page-embedded-1/";
    @XNodeMap(value="startupPages/startupPage", key="@id", type=HashMap.class, componentType=LoginStartupPage.class)
    protected Map<String, LoginStartupPage> startupPages = new HashMap<String, LoginStartupPage>();
    @XNodeList(value="loginProviders/loginProvider", type=ArrayList.class, componentType=LoginProviderLink.class)
    protected List<LoginProviderLink> providers;
    @XNodeList(value="videos/video", type=ArrayList.class, componentType=LoginVideo.class, nullByDefault=true)
    protected List<LoginVideo> videos;
    @XNode(value="videos@muted")
    protected Boolean muted;
    @XNode(value="videos@loop")
    protected Boolean loop;
    @XNode(value="backgroundImage")
    protected String backgroundImage;
    @XNode(value="removeNews")
    protected Boolean removeNews = false;
    @XNode(value="headerStyle")
    protected String headerStyle;
    @XNode(value="footerStyle")
    protected String footerStyle;
    protected String newsIframeUrl = "//www.nuxeo.com/login-page-embedded-1/";
    protected String newsIframeFullUrl = null;
    @XNode(value="bodyBackgroundStyle")
    protected String bodyBackgroundStyle;
    @XNode(value="loginBoxBackgroundStyle")
    protected String loginBoxBackgroundStyle;
    @XNode(value="loginBoxWidth")
    protected String loginBoxWidth;
    @XNode(value="logoUrl")
    protected String logoUrl;
    @XNode(value="logoAlt")
    protected String logoAlt;
    @XNode(value="logoWidth")
    protected String logoWidth;
    @XNode(value="logoHeight")
    protected String logoHeight;
    @XNode(value="fieldAutocomplete")
    protected Boolean fieldAutocomplete;
    @XNode(value="disableBackgroundSizeCover")
    protected Boolean disableBackgroundSizeCover;
    @XNode(value="loginButtonBackgroundColor")
    protected String loginButtonBackgroundColor;
    @XNode(value="defaultLocale")
    protected String defaultLocale;
    @XNode(value="supportedLocales@append")
    Boolean appendSupportedLocales;
    @XNodeList(value="supportedLocales/locale", type=ArrayList.class, componentType=String.class)
    List<String> supportedLocales;

    public LoginScreenConfig() {
    }

    public LoginScreenConfig(LoginProviderLink provider) {
        this.providers = new ArrayList<LoginProviderLink>();
        this.providers.add(provider);
    }

    public List<LoginProviderLink> getProviders() {
        return this.providers;
    }

    public LoginProviderLink getProvider(String name) {
        if (this.getProviders() == null) {
            return null;
        }
        for (LoginProviderLink provider : this.getProviders()) {
            if (!name.equals(provider.getName())) continue;
            return provider;
        }
        return null;
    }

    public Map<String, LoginStartupPage> getStartupPages() {
        return this.startupPages;
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }

    public String getFooterStyle() {
        return this.footerStyle;
    }

    public String getBodyBackgroundStyle() {
        return this.bodyBackgroundStyle;
    }

    public String getLoginBoxBackgroundStyle() {
        return this.loginBoxBackgroundStyle;
    }

    public String getLoginBoxWidth() {
        return this.loginBoxWidth;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public String getLogoAlt() {
        return this.logoAlt;
    }

    public String getLogoWidth() {
        return this.logoWidth;
    }

    public String getLogoHeight() {
        return this.logoHeight;
    }

    public List<LoginVideo> getVideos() {
        return this.videos;
    }

    public Boolean getVideoMuted() {
        return this.muted == null ? false : this.muted;
    }

    public Boolean getVideoLoop() {
        return this.loop == null ? true : this.loop;
    }

    public boolean hasVideos() {
        return this.videos != null && !this.videos.isEmpty();
    }

    public boolean getDisplayNews() {
        return this.removeNews == false && !StringUtils.isBlank((CharSequence)this.newsIframeUrl);
    }

    public Boolean getFieldAutocomplete() {
        return this.fieldAutocomplete == null ? true : this.fieldAutocomplete;
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public String getLoginButtonBackgroundColor() {
        return this.loginButtonBackgroundColor;
    }

    @XNode(value="newsIframeUrl")
    public void setNewsIframeUrl(String newsIframeUrl) {
        this.newsIframeUrl = newsIframeUrl;
        this.newsIframeFullUrl = null;
    }

    public String getNewsIframeUrl() {
        if (this.newsIframeFullUrl == null) {
            UriBuilder newsIFrameBuilder = UriBuilder.fromPath((String)this.newsIframeUrl);
            if (NUXEO_NEWS_URL.equals(this.newsIframeUrl)) {
                newsIFrameBuilder.queryParam("org.nuxeo.ecm.product.version", new Object[]{Framework.getProperty((String)"org.nuxeo.ecm.product.version")}).queryParam("org.nuxeo.distribution.version", new Object[]{Framework.getProperty((String)"org.nuxeo.distribution.version")}).queryParam("org.nuxeo.distribution.package", new Object[]{Framework.getProperty((String)"org.nuxeo.distribution.package")});
            }
            this.newsIframeFullUrl = newsIFrameBuilder.build(new Object[0]).toString();
        }
        try {
            return URLDecoder.decode(this.newsIframeFullUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new NuxeoException("Cannot decode login iframe URL " + this.newsIframeFullUrl);
        }
    }

    public Boolean getDisableBackgroundSizeCover() {
        return this.disableBackgroundSizeCover;
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public Boolean isAppendSupportedLocales() {
        return this.appendSupportedLocales;
    }

    public List<String> getSupportedLocales() {
        String defaultLocale;
        ArrayList<String> res = new ArrayList<String>();
        if (this.supportedLocales != null) {
            res.addAll(this.supportedLocales);
        }
        if ((defaultLocale = this.getDefaultLocale()) != null && !res.contains(defaultLocale)) {
            res.add(defaultLocale);
        }
        return res;
    }

    protected void merge(LoginScreenConfig newConfig) {
        if (newConfig.newsIframeUrl != null) {
            this.setNewsIframeUrl(newConfig.newsIframeUrl);
        }
        if (newConfig.headerStyle != null) {
            this.headerStyle = newConfig.headerStyle;
        }
        if (newConfig.footerStyle != null) {
            this.footerStyle = newConfig.footerStyle;
        }
        if (newConfig.bodyBackgroundStyle != null) {
            this.bodyBackgroundStyle = newConfig.bodyBackgroundStyle;
        }
        if (newConfig.loginBoxBackgroundStyle != null) {
            this.loginBoxBackgroundStyle = newConfig.loginBoxBackgroundStyle;
        }
        if (newConfig.loginBoxWidth != null) {
            this.loginBoxWidth = newConfig.loginBoxWidth;
        }
        if (newConfig.disableBackgroundSizeCover != null) {
            this.disableBackgroundSizeCover = newConfig.disableBackgroundSizeCover;
        }
        if (newConfig.logoAlt != null) {
            this.logoAlt = newConfig.logoAlt;
        }
        if (newConfig.logoHeight != null) {
            this.logoHeight = newConfig.logoHeight;
        }
        if (newConfig.logoUrl != null) {
            this.logoUrl = newConfig.logoUrl;
        }
        if (newConfig.logoWidth != null) {
            this.logoWidth = newConfig.logoWidth;
        }
        if (newConfig.fieldAutocomplete != null) {
            this.fieldAutocomplete = newConfig.fieldAutocomplete;
        }
        if (newConfig.videos != null) {
            this.videos = newConfig.videos;
        }
        if (newConfig.loop != null) {
            this.loop = newConfig.loop;
        }
        if (newConfig.removeNews.booleanValue()) {
            this.removeNews = newConfig.removeNews;
        }
        if (newConfig.muted != null) {
            this.muted = newConfig.muted;
        }
        if (newConfig.loginButtonBackgroundColor != null) {
            this.loginButtonBackgroundColor = newConfig.loginButtonBackgroundColor;
        }
        if (newConfig.backgroundImage != null) {
            this.backgroundImage = newConfig.backgroundImage;
        }
        if (this.providers == null) {
            this.providers = newConfig.providers;
        } else if (newConfig.providers != null && newConfig.providers.size() > 0) {
            for (LoginProviderLink loginProviderLink : newConfig.providers) {
                int idx = this.providers.indexOf(loginProviderLink);
                if (idx >= 0) {
                    if (loginProviderLink.remove) {
                        this.providers.remove(idx);
                        continue;
                    }
                    this.providers.get(idx).merge(loginProviderLink);
                    continue;
                }
                this.providers.add(loginProviderLink);
            }
        }
        if (this.startupPages == null) {
            this.startupPages = newConfig.startupPages;
        } else if (newConfig.startupPages != null && !newConfig.startupPages.isEmpty()) {
            for (Map.Entry entry : newConfig.startupPages.entrySet()) {
                if (this.startupPages.containsKey(entry.getKey())) {
                    this.startupPages.get(entry.getKey()).merge((LoginStartupPage)entry.getValue());
                    continue;
                }
                this.startupPages.put((String)entry.getKey(), (LoginStartupPage)entry.getValue());
            }
        }
        if (newConfig.defaultLocale != null) {
            this.defaultLocale = newConfig.defaultLocale;
        }
        Boolean append = newConfig.isAppendSupportedLocales();
        List<String> list = newConfig.getSupportedLocales();
        HashSet<String> mergedLocales = new HashSet<String>();
        if (!Boolean.FALSE.equals(append) && this.supportedLocales != null) {
            mergedLocales.addAll(this.supportedLocales);
        }
        if (list != null) {
            mergedLocales.addAll(list);
        }
        this.supportedLocales = new ArrayList<String>(mergedLocales);
    }
}

