/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.platform.ui.web.auth.CachableUserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationSessionManager;
import org.nuxeo.ecm.platform.ui.web.auth.service.AuthenticationChainDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.AuthenticationPluginDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginScreenConfig;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginScreenConfigRegistry;
import org.nuxeo.ecm.platform.ui.web.auth.service.OpenUrlDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.SpecificAuthChainDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.StartURLPatternDescriptor;
import org.nuxeo.ecm.platform.web.common.session.NuxeoHttpSessionMonitor;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class PluggableAuthenticationService
extends DefaultComponent {
    private static final Logger log = LogManager.getLogger(PluggableAuthenticationService.class);
    public static final String NAME = "org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService";
    public static final String EP_AUTHENTICATOR = "authenticators";
    public static final String EP_SESSIONMANAGER = "sessionManager";
    public static final String EP_CHAIN = "chain";
    public static final String EP_SPECIFIC_CHAINS = "specificChains";
    public static final String EP_STARTURL = "startURL";
    public static final String EP_OPENURL = "openUrl";
    public static final String EP_LOGINSCREEN = "loginScreen";
    private Map<String, NuxeoAuthenticationPlugin> authenticators;
    private Map<String, NuxeoAuthenticationSessionManager> sessionManagers;
    private List<String> authChain;
    private List<NuxeoAuthenticationPlugin> authPluginChain;

    public void start(ComponentContext context) {
        this.authenticators = new HashMap<String, NuxeoAuthenticationPlugin>();
        this.getRegistryContributions(EP_AUTHENTICATOR).forEach(desc -> {
            String name = desc.getName();
            try {
                NuxeoAuthenticationPlugin authPlugin = desc.getClassName().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                authPlugin.initPlugin(desc.getParameters());
                this.authenticators.put(name, authPlugin);
            }
            catch (ReflectiveOperationException e) {
                String msg = String.format("Unable to create AuthPlugin with name '%s' (%s)", name, e.getMessage());
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, msg);
                log.error(msg, (Throwable)e);
            }
        });
        this.authChain = this.getRegistryContribution(EP_CHAIN).map(AuthenticationChainDescriptor::getPluginsNames).orElse(Collections.emptyList());
        this.authPluginChain = this.authChain.stream().filter(this.authenticators::containsKey).map(this.authenticators::get).collect(Collectors.toList());
        this.sessionManagers = new HashMap<String, NuxeoAuthenticationSessionManager>();
        this.getRegistryContributions(EP_SESSIONMANAGER).forEach(desc -> {
            String name = desc.getName();
            try {
                NuxeoAuthenticationSessionManager sm = desc.getClassName().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.sessionManagers.put(name, sm);
            }
            catch (ReflectiveOperationException e) {
                log.error("Unable to create session manager", (Throwable)e);
            }
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.authenticators = null;
        this.authChain = null;
        this.authPluginChain = null;
        this.sessionManagers = null;
    }

    public List<String> getStartURLPatterns() {
        return this.getRegistryContribution(EP_STARTURL).map(StartURLPatternDescriptor::getStartURLPatterns).orElse(Collections.emptyList());
    }

    public List<String> getAuthChain() {
        return Collections.unmodifiableList(this.authChain);
    }

    public List<String> getAuthChain(HttpServletRequest request) {
        List specificAuthChains = this.getRegistryContributions(EP_SPECIFIC_CHAINS);
        if (specificAuthChains.isEmpty()) {
            return this.authChain;
        }
        return this.getAuthChainDescriptor(request).map(desc -> desc.computeResultingChain(this.authChain)).orElse(this.authChain);
    }

    public boolean doHandlePrompt(HttpServletRequest request) {
        List specificAuthChains = this.getRegistryContributions(EP_SPECIFIC_CHAINS);
        if (specificAuthChains.isEmpty()) {
            return true;
        }
        return this.getAuthChainDescriptor(request).map(SpecificAuthChainDescriptor::doHandlePrompt).orElse(true);
    }

    private Optional<SpecificAuthChainDescriptor> getAuthChainDescriptor(HttpServletRequest request) {
        String specificAuthChainName = this.getSpecificAuthChainName(request);
        return this.getRegistryContribution(EP_SPECIFIC_CHAINS, specificAuthChainName);
    }

    public String getSpecificAuthChainName(HttpServletRequest request) {
        List specificAuthChains = this.getRegistryContributions(EP_SPECIFIC_CHAINS);
        for (SpecificAuthChainDescriptor desc : specificAuthChains) {
            String name = desc.getName();
            String requestUrl = request.getRequestURI();
            for (Pattern pattern : desc.getUrlPatterns()) {
                Matcher m = pattern.matcher(requestUrl);
                if (!m.matches()) continue;
                return name;
            }
            for (Map.Entry entry : desc.getHeaderPatterns().entrySet()) {
                Matcher m;
                String headerValue = request.getHeader((String)entry.getKey());
                if (headerValue == null || !(m = ((Pattern)entry.getValue()).matcher(headerValue)).matches()) continue;
                return name;
            }
        }
        return null;
    }

    public List<NuxeoAuthenticationPlugin> getPluginChain() {
        return Collections.unmodifiableList(this.authPluginChain);
    }

    public NuxeoAuthenticationPlugin getPlugin(String pluginName) {
        return this.authenticators.get(pluginName);
    }

    public AuthenticationPluginDescriptor getDescriptor(String pluginName) {
        return this.getRegistryContribution(EP_AUTHENTICATOR, pluginName).orElseGet(() -> {
            log.error("Plugin '{}' not registered or not created", (Object)pluginName);
            return null;
        });
    }

    public void invalidateSession(ServletRequest request) {
        HttpServletRequest httpRequest;
        HttpSession session;
        boolean done = false;
        Iterator<NuxeoAuthenticationSessionManager> it = this.sessionManagers.values().iterator();
        while (it.hasNext() && !(done = it.next().invalidateSession(request))) {
        }
        if (!done && (session = (httpRequest = (HttpServletRequest)request).getSession(false)) != null) {
            session.invalidate();
        }
    }

    public HttpSession reinitSession(HttpServletRequest httpRequest) {
        this.sessionManagers.values().forEach(sm -> sm.onBeforeSessionReinit((ServletRequest)httpRequest));
        HttpSession session = httpRequest.getSession(true);
        this.sessionManagers.values().forEach(sm -> sm.onAfterSessionReinit((ServletRequest)httpRequest));
        return session;
    }

    public boolean canBypassRequest(ServletRequest request) {
        return this.sessionManagers.values().stream().anyMatch(sm -> sm.canBypassRequest(request));
    }

    public boolean needResetLogin(ServletRequest request) {
        return this.sessionManagers.values().stream().anyMatch(sm -> sm.needResetLogin(request));
    }

    public String getBaseURL(ServletRequest request) {
        return VirtualHostHelper.getBaseURL(request);
    }

    public void onAuthenticatedSessionCreated(ServletRequest request, HttpSession session, CachableUserIdentificationInfo cachebleUserInfo) {
        NuxeoHttpSessionMonitor.instance().associatedUser(session, cachebleUserInfo.getPrincipal().getName());
        this.sessionManagers.values().forEach(sm -> sm.onAuthenticatedSessionCreated(request, session, cachebleUserInfo));
    }

    public List<OpenUrlDescriptor> getOpenUrls() {
        return this.getRegistryContributions(EP_OPENURL);
    }

    public LoginScreenConfig getLoginScreenConfig() {
        return this.getRegistryContribution(EP_LOGINSCREEN).orElse(null);
    }

    protected LoginScreenConfigRegistry getLoginScreenConfigRegistry() {
        return (LoginScreenConfigRegistry)this.getExtensionPointRegistry(EP_LOGINSCREEN);
    }

    public void registerLoginScreenConfig(LoginScreenConfig config) {
        this.getLoginScreenConfigRegistry().addContribution(config);
    }

    public void unregisterLoginScreenConfig(LoginScreenConfig config) {
        this.getLoginScreenConfigRegistry().removeContribution(config);
    }
}

