/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.idempotency;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.apache.commons.io.output.DeferredFileOutputStream;

public class CopyingServletOutputStream
extends ServletOutputStream {
    protected final ServletOutputStream output;
    protected final DeferredFileOutputStream copy;

    public CopyingServletOutputStream(ServletOutputStream output, DeferredFileOutputStream copy) {
        this.output = output;
        this.copy = copy;
    }

    public void write(int b) throws IOException {
        this.output.write(b);
        this.copy.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.output.write(b);
        this.copy.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.output.write(b, off, len);
        this.copy.write(b, off, len);
    }

    public void flush() throws IOException {
        this.output.flush();
        this.copy.flush();
    }

    public void close() throws IOException {
        this.output.close();
        this.copy.close();
    }

    public boolean isReady() {
        return this.output.isReady();
    }

    public void setWriteListener(WriteListener writeListener) {
        this.output.setWriteListener(writeListener);
    }
}

