/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.filter;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentManager;

public class NuxeoStandbyFilter
implements Filter {
    protected Controller controller;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.controller = new Controller();
        new ComponentManager.Listener(){

            public void beforeStop(ComponentManager mgr, boolean isStandby) {
                NuxeoStandbyFilter.this.controller.onStandby();
            }

            public void afterStart(ComponentManager mgr, boolean isResume) {
                NuxeoStandbyFilter.this.controller.onResumed();
            }
        }.install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.controller.onNewRequest();
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.controller.onRequestEnd();
        }
    }

    public void destroy() {
    }

    protected static class Controller {
        protected final Lock lock = new ReentrantLock();
        protected final Condition canStandby = this.lock.newCondition();
        protected final Condition canProceed = this.lock.newCondition();
        protected volatile boolean isStandby = !Framework.getRuntime().getComponentManager().isStarted();
        protected final AtomicInteger inProgress = new AtomicInteger();
        protected final ThreadLocal<Boolean> hasBeenFiltered = ThreadLocal.withInitial(() -> Boolean.FALSE);

        protected Controller() {
        }

        public void onNewRequest() {
            if (this.isStandby) {
                this.awaitCanProceed();
            }
            this.inProgress.incrementAndGet();
            this.hasBeenFiltered.set(Boolean.TRUE);
        }

        public void onRequestEnd() {
            this.hasBeenFiltered.set(Boolean.FALSE);
            if (this.inProgress.decrementAndGet() <= 0) {
                this.signalBlockedToStandby();
            }
        }

        public void onStandby() throws RuntimeException {
            this.isStandby = true;
            if (this.hasBeenFiltered.get().booleanValue()) {
                this.inProgress.decrementAndGet();
            }
            if (this.inProgress.get() > 0) {
                this.awaitCanStandby();
            }
        }

        public void onResumed() {
            this.isStandby = false;
            if (this.hasBeenFiltered.get().booleanValue()) {
                this.inProgress.incrementAndGet();
            }
            this.signalBlockedToProceed();
        }

        protected void awaitCanProceed() throws RuntimeException {
            this.lock.lock();
            try {
                this.canProceed.await();
            }
            catch (InterruptedException cause) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while locking incoming requests", cause);
            }
            finally {
                this.lock.unlock();
            }
        }

        protected void awaitCanStandby() throws RuntimeException {
            this.lock.lock();
            try {
                this.canStandby.await();
            }
            catch (InterruptedException cause) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while waiting for web requests being drained", cause);
            }
            finally {
                this.lock.unlock();
            }
        }

        protected void signalBlockedToProceed() {
            this.lock.lock();
            try {
                this.canProceed.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        protected void signalBlockedToStandby() {
            this.lock.lock();
            try {
                this.canStandby.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

