/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.service;

import com.thetransactioncompany.cors.CORSFilter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;

@XObject(value="corsConfig")
@XRegistry(enable=false)
public class NuxeoCorsFilterDescriptor {
    private static final String PROPERTIES_PREFIX = "cors.";
    @XNode(value="@name")
    @XRegistryId
    protected String name;
    @XNode(value="@enable", fallback="@enabled")
    @XEnable
    protected Boolean enabled;
    @XNode(value="@allowGenericHttpRequests")
    protected Boolean allowGenericHttpRequests = true;
    @XNode(value="@allowOrigin")
    protected String allowOrigin;
    @XNode(value="@allowSubdomains")
    protected boolean allowSubdomains = false;
    @XNode(value="@supportedMethods")
    protected String supportedMethods;
    @XNode(value="@supportedHeaders")
    protected String supportedHeaders;
    @XNode(value="@exposedHeaders")
    protected String exposedHeaders;
    @XNode(value="@supportsCredentials")
    protected Boolean supportsCredentials = true;
    @XNode(value="@maxAge")
    protected int maxAge = -1;
    protected Pattern pattern;
    protected volatile CORSFilter filter;

    @XNode(value="pattern")
    public void setPattern(String patternString) {
        if (!StringUtils.isBlank((CharSequence)(patternString = Framework.expandVars((String)patternString)))) {
            this.pattern = Pattern.compile(patternString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CORSFilter getFilter() {
        if (this.filter == null) {
            NuxeoCorsFilterDescriptor nuxeoCorsFilterDescriptor = this;
            synchronized (nuxeoCorsFilterDescriptor) {
                if (this.filter == null) {
                    CORSFilter corsFilter = new CORSFilter();
                    try {
                        corsFilter.init(this.buildFilterConfig());
                    }
                    catch (ServletException e) {
                        throw new NuxeoException((Throwable)e);
                    }
                    this.filter = corsFilter;
                }
            }
        }
        return this.filter;
    }

    protected FilterConfig buildFilterConfig() {
        final Dictionary<String, String> parameters = this.buildDictionary();
        return new FilterConfig(){

            public String getFilterName() {
                return "NuxeoCorsFilterDescriptor";
            }

            public ServletContext getServletContext() {
                return null;
            }

            public String getInitParameter(String name) {
                return (String)parameters.get(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return parameters.keys();
            }
        };
    }

    protected Dictionary<String, String> buildDictionary() {
        Hashtable<String, String> params = new Hashtable<String, String>();
        ((Dictionary)params).put("cors.allowGenericHttpRequests", Boolean.toString(this.allowGenericHttpRequests));
        if (!StringUtils.isEmpty((CharSequence)this.allowOrigin)) {
            ((Dictionary)params).put("cors.allowOrigin", this.allowOrigin);
        }
        ((Dictionary)params).put("cors.allowSubdomains", Boolean.toString(this.allowSubdomains));
        if (!StringUtils.isEmpty((CharSequence)this.supportedMethods)) {
            ((Dictionary)params).put("cors.supportedMethods", this.supportedMethods);
        }
        if (!StringUtils.isEmpty((CharSequence)this.supportedHeaders)) {
            ((Dictionary)params).put("cors.supportedHeaders", this.supportedHeaders);
        }
        if (!StringUtils.isEmpty((CharSequence)this.exposedHeaders)) {
            ((Dictionary)params).put("cors.exposedHeaders", this.exposedHeaders);
        }
        ((Dictionary)params).put("cors.supportsCredentials", Boolean.toString(this.supportsCredentials));
        ((Dictionary)params).put("cors.maxAge", Integer.toString(this.maxAge));
        return params;
    }
}

