/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.webengine.ResourceBinding;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.security.PermissionService;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class WebEngineComponent
extends DefaultComponent {
    private static final Logger log = LogManager.getLogger(WebEngineComponent.class);
    public static final ComponentName NAME = new ComponentName(WebEngineComponent.class.getName());
    public static final String RENDERING_EXTENSION_XP = "rendering-extension";
    public static final String RESOURCE_BINDING_XP = "resource";
    public static final String REQUEST_CONFIGURATION_XP = "request-configuration";
    public static final String GUARD_XP = "guard";
    public static final String FORM_XP = "form";
    private WebEngine engine;
    private Set<String> renderingExtensions;

    public void activate(ComponentContext context) {
        super.activate(context);
        String webDir = Framework.getProperty((String)"org.nuxeo.ecm.web.root");
        File root = webDir != null ? new File(webDir) : new File(Framework.getRuntime().getHome(), "web");
        try {
            root = root.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.info("Using web root: '{}'", (Object)root);
        this.engine = new WebEngine(new File(root, "root.war"));
    }

    public void deactivate(ComponentContext context) {
        this.engine = null;
        super.deactivate(context);
    }

    public void start(ComponentContext context) {
        this.getRegistryContributions(GUARD_XP).forEach(gd -> {
            try {
                PermissionService.getInstance().registerGuard(gd.getId(), gd.getGuard());
            }
            catch (ParseException e) {
                String msg = String.format("Error registering guard '%s': %s", gd.getId(), e.getMessage());
                log.error(msg, (Throwable)e);
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, msg);
            }
        });
        this.renderingExtensions = new HashSet<String>();
        this.getRegistryContributions(RENDERING_EXTENSION_XP).forEach(fed -> {
            try {
                this.engine.registerRenderingExtension(fed.name, fed.newInstance());
                this.renderingExtensions.add(fed.name);
            }
            catch (ReflectiveOperationException e) {
                String msg = String.format("Error contributing freemarker template extension '%s': %s", fed.name, e.getMessage());
                log.error(msg, (Throwable)e);
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, msg);
            }
        });
        this.engine.start();
    }

    public void stop(ComponentContext context) {
        PermissionService.getInstance().clearGuards();
        this.renderingExtensions.forEach(this.engine::unregisterRenderingExtension);
        this.renderingExtensions = null;
        this.engine.stop();
    }

    public WebEngine getEngine() {
        return this.engine;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (RESOURCE_BINDING_XP.equals(extensionPoint)) {
            this.addRuntimeMessage(RuntimeMessage.Level.WARNING, String.format("Extension point '%s' is obsolete since 5.8: use a JAX-RS application to declare more resources.", RESOURCE_BINDING_XP), RuntimeMessage.Source.EXTENSION, contributor.getName().getName());
            this.engine.addResourceBinding((ResourceBinding)contribution);
        } else if (extensionPoint.equals(REQUEST_CONFIGURATION_XP)) {
            this.addRuntimeMessage(RuntimeMessage.Level.WARNING, String.format("Extension point '%s' is obsolete since 8.4, transactions are always active.", REQUEST_CONFIGURATION_XP), RuntimeMessage.Source.EXTENSION, contributor.getName().getName());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (RESOURCE_BINDING_XP.equals(extensionPoint)) {
            this.engine.removeResourceBinding((ResourceBinding)contribution);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == WebEngine.class) {
            return adapter.cast(this.engine);
        }
        return null;
    }
}

