/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.util.List;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.nuxeo.runtime.datasource.DataSourceDescriptor;
import org.nuxeo.runtime.datasource.DataSourceLinkDescriptor;
import org.w3c.dom.Element;

public class DataSourceRegistry
implements Registry {
    protected MapRegistry registry = new MapRegistry();
    protected MapRegistry linkRegistry = new MapRegistry();

    public void initialize() {
        this.registry.initialize();
        this.linkRegistry.initialize();
    }

    public void tag(String id) {
        this.registry.tag(id);
        this.linkRegistry.tag(id);
    }

    public boolean isTagged(String id) {
        return this.registry.isTagged(id) || this.linkRegistry.isTagged(id);
    }

    public void register(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        Class klass = xObject.getKlass();
        if (DataSourceDescriptor.class.equals((Object)klass)) {
            this.registry.register(ctx, xObject, element, tag);
        } else if (DataSourceLinkDescriptor.class.equals((Object)klass)) {
            this.linkRegistry.register(ctx, xObject, element, tag);
        } else {
            throw new IllegalArgumentException("Unsupported class " + klass);
        }
    }

    public void unregister(String tag) {
        this.registry.unregister(tag);
        this.linkRegistry.unregister(tag);
    }

    public List<DataSourceDescriptor> getDataSources() {
        return this.registry.getContributionValues();
    }

    public List<DataSourceLinkDescriptor> getDataSourceLinks() {
        return this.linkRegistry.getContributionValues();
    }
}

