/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.registry.Registry;
import org.nuxeo.ecm.core.schema.PropertyDescriptor;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.w3c.dom.Element;

public class PropertyDeprecationDescriptorRegistry
implements Registry {
    protected static XAnnotatedObject xProperty;

    protected Registry getTargetRegistry() {
        return (Registry)Framework.getRuntime().getComponentManager().getExtensionPointRegistry("org.nuxeo.ecm.core.schema.TypeService", "schema").orElseThrow(() -> new IllegalArgumentException(String.format("Unknown registry for extension point '%s--%s'", "org.nuxeo.ecm.core.schema.TypeService", "schema")));
    }

    public void tag(String id) {
        this.getTargetRegistry().tag(id);
    }

    public boolean isTagged(String id) {
        return this.getTargetRegistry().isTagged(id);
    }

    public void register(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        String message = String.format("Deprecation contribution on extension '%s' should now be contributed to extension point '%s'", tag, "schema");
        DeprecationLogger.log((String)message, (String)"11.1");
        Framework.getRuntime().getMessageHandler().addMessage(new RuntimeMessage(RuntimeMessage.Level.WARNING, message, RuntimeMessage.Source.EXTENSION, tag));
        String deprecated = element.getAttribute("deprecated");
        element.setAttribute("deprecation", Boolean.parseBoolean(deprecated) ? "deprecated" : "removed");
        this.getTargetRegistry().register(ctx, xProperty, element, tag);
    }

    public void unregister(String tag) {
        this.getTargetRegistry().unregister(tag);
    }

    static {
        XMap xmap = new XMap();
        xmap.register(PropertyDescriptor.class);
        xProperty = xmap.getObject(PropertyDescriptor.class);
    }
}

