/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.core.schema.SchemaBindingDescriptor;
import org.w3c.dom.Element;

public class SchemaBindingRegistry
extends MapRegistry {
    private static final Logger log = LogManager.getLogger(SchemaBindingRegistry.class);

    protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        String id = this.computeId(ctx, xObject, element);
        if (this.shouldRemove(ctx, xObject, element, extensionId)) {
            this.contributions.remove(id);
            return null;
        }
        SchemaBindingDescriptor contrib = (SchemaBindingDescriptor)this.getInstance(ctx, xObject, element);
        SchemaBindingDescriptor existing = (SchemaBindingDescriptor)this.contributions.get(id);
        if (existing != null && !contrib.override) {
            log.warn("Schema {} is redefined but will not be overridden", (Object)id);
        } else {
            if (existing != null) {
                log.debug("Re-registering schema: {} from {}", (Object)id, (Object)contrib.src);
            } else {
                log.debug("Registering schema: {} from {}", (Object)id, (Object)contrib.src);
            }
            this.contributions.put(id, contrib);
        }
        Boolean enable = this.shouldEnable(ctx, xObject, element, extensionId);
        if (enable != null) {
            if (Boolean.TRUE.equals(enable)) {
                this.disabled.remove(id);
            } else {
                this.disabled.add(id);
            }
        }
        return (T)contrib;
    }
}

