/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.Environment;
import org.nuxeo.common.xmap.registry.SingleRegistry;
import org.nuxeo.ecm.core.schema.DocTypeRegistry;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.DocumentTypeImpl;
import org.nuxeo.ecm.core.schema.FacetDescriptor;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.PropertyDeprecationHandler;
import org.nuxeo.ecm.core.schema.PropertyDescriptor;
import org.nuxeo.ecm.core.schema.ProxiesDescriptor;
import org.nuxeo.ecm.core.schema.SchemaBindingDescriptor;
import org.nuxeo.ecm.core.schema.SchemaDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.SchemaRegistry;
import org.nuxeo.ecm.core.schema.TypeConfiguration;
import org.nuxeo.ecm.core.schema.XSDLoader;
import org.nuxeo.ecm.core.schema.XSDTypes;
import org.nuxeo.ecm.core.schema.types.AnyType;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.CompositeTypeImpl;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.nuxeo.runtime.RuntimeServiceException;
import org.xml.sax.SAXException;

public class SchemaManagerImpl
implements SchemaManager {
    private static final Logger log = LogManager.getLogger(SchemaManagerImpl.class);
    protected static final TypeConfiguration DEFAULT_CONFIGURATION = new TypeConfiguration();
    protected PrefetchInfo prefetchInfo;
    public boolean clearComplexPropertyBeforeSet;
    protected boolean allowVersionWriteForDublinCore;
    protected Map<String, Type> types = new LinkedHashMap<String, Type>();
    protected Map<String, Schema> schemas = new LinkedHashMap<String, Schema>();
    protected Set<String> disabledSchemas = new HashSet<String>();
    protected final Map<String, Schema> prefixToSchema = new HashMap<String, Schema>();
    public Map<String, CompositeType> facets = new LinkedHashMap<String, CompositeType>();
    protected Set<String> noPerDocumentQueryFacets = new HashSet<String>();
    protected Set<String> disabledFacets = new HashSet<String>();
    protected Map<String, DocumentTypeImpl> documentTypes = new LinkedHashMap<String, DocumentTypeImpl>();
    protected Set<String> specialDocumentTypes = new HashSet<String>();
    protected Map<String, Set<String>> documentTypesExtending = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> documentTypesForFacet = new HashMap<String, Set<String>>();
    protected List<Schema> proxySchemas = new ArrayList<Schema>();
    protected Set<String> proxySchemaNames = new LinkedHashSet<String>();
    private Map<String, Field> fields = new ConcurrentHashMap<String, Field>();
    private File schemaDir;
    public static final String SCHEMAS_DIR_NAME = "schemas";
    @Deprecated(since="11.1")
    protected Map<String, Map<String, String>> deprecatedProperties = new HashMap<String, Map<String, String>>();
    @Deprecated(since="11.1")
    protected Map<String, Map<String, String>> removedProperties = new HashMap<String, Map<String, String>>();
    protected Map<String, Map<String, PropertyDescriptor>> propertyCharacteristics = Map.of();

    public SchemaManagerImpl(SingleRegistry configRegistry, SchemaRegistry schemaRegistry, DocTypeRegistry doctypeRegistry) {
        this.schemaDir = new File(Environment.getDefault().getTemp(), SCHEMAS_DIR_NAME);
        if (!this.schemaDir.mkdirs() && !this.schemaDir.exists()) {
            throw new RuntimeServiceException("Unable to create schemas directory");
        }
        this.clearSchemaDir();
        this.registerBuiltinTypes();
        this.computeConfiguration(configRegistry.getContribution().orElse(DEFAULT_CONFIGURATION));
        this.disabledSchemas = schemaRegistry.getDisabledSchemas();
        this.computeSchemas(schemaRegistry.getSchemas());
        this.disabledFacets = doctypeRegistry.getDisabledFacets();
        this.computeFacets(doctypeRegistry.getFacets());
        this.computeDocumentTypes(doctypeRegistry.getDocumentTypes());
        this.computeProxies(doctypeRegistry.getProxies());
        this.computePropertyCharacteristics(schemaRegistry.getProperties());
    }

    protected void clearSchemaDir() {
        try {
            FileUtils.cleanDirectory((File)this.schemaDir);
        }
        catch (IOException e) {
            throw new RuntimeServiceException((Throwable)e);
        }
    }

    public File getSchemasDir() {
        return this.schemaDir;
    }

    protected void registerBuiltinTypes() {
        for (Type type : XSDTypes.getTypes()) {
            this.registerType(type);
        }
        this.registerType(AnyType.INSTANCE);
    }

    protected void registerType(Type type) {
        this.types.put(type.getName(), type);
    }

    protected Type getType(String name) {
        return this.types.get(name);
    }

    protected Collection<Type> getTypes() {
        return this.types.values();
    }

    protected void computeConfiguration(TypeConfiguration config) {
        log.info("Using global prefetch: {}", (Object)config.prefetchInfo);
        if (StringUtils.isNotBlank((CharSequence)config.prefetchInfo)) {
            this.prefetchInfo = new PrefetchInfo(config.prefetchInfo);
        }
        log.info("Using clearComplexPropertyBeforeSet: {}", (Object)config.clearComplexPropertyBeforeSet);
        this.clearComplexPropertyBeforeSet = config.clearComplexPropertyBeforeSet;
        log.info("Using allowVersionWriteForDublinCore: {}", (Object)config.allowVersionWriteForDublinCore);
        this.allowVersionWriteForDublinCore = config.allowVersionWriteForDublinCore;
    }

    protected void computeSchemas(Map<String, SchemaBindingDescriptor> resolvedSchemas) {
        this.schemas.clear();
        this.prefixToSchema.clear();
        RuntimeException errors = new RuntimeException("Cannot load schemas");
        for (SchemaBindingDescriptor sd : resolvedSchemas.values()) {
            try {
                this.copySchema(sd);
            }
            catch (IOException error) {
                errors.addSuppressed(error);
            }
        }
        for (SchemaBindingDescriptor sd : resolvedSchemas.values()) {
            try {
                this.loadSchema(sd);
            }
            catch (IOException | TypeException | SAXException error) {
                errors.addSuppressed(error);
            }
        }
        if (errors.getSuppressed().length > 0) {
            throw errors;
        }
    }

    protected void copySchema(SchemaBindingDescriptor sd) throws IOException {
        if (sd.src == null) {
            return;
        }
        URL url = sd.src.toURL();
        if (url == null) {
            log.error("XSD Schema not found: {}", (Object)sd.src);
            return;
        }
        try (InputStream in = url.openStream();){
            sd.file = new File(this.schemaDir, sd.name + ".xsd");
            FileUtils.copyInputStreamToFile((InputStream)in, (File)sd.file);
        }
    }

    protected void loadSchema(SchemaBindingDescriptor sd) throws IOException, SAXException, TypeException {
        if (sd.file == null) {
            return;
        }
        XSDLoader schemaLoader = new XSDLoader(this, sd);
        schemaLoader.loadSchema(sd.name, sd.prefix, sd.file, sd.xsdRootElement, sd.isVersionWritable);
        log.info("Registered schema: {} from {}", (Object)sd.name, (Object)sd.file);
    }

    protected void registerSchema(Schema schema) {
        this.schemas.put(schema.getName(), schema);
        Namespace ns = schema.getNamespace();
        if (!StringUtils.isBlank((CharSequence)ns.prefix)) {
            this.prefixToSchema.put(ns.prefix, schema);
        }
    }

    @Override
    public Schema[] getSchemas() {
        return new ArrayList<Schema>(this.schemas.values()).toArray(new Schema[0]);
    }

    @Override
    public Schema getSchema(String name) {
        return this.schemas.get(name);
    }

    @Override
    public Schema getSchemaFromPrefix(String schemaPrefix) {
        return this.prefixToSchema.get(schemaPrefix);
    }

    @Override
    @Deprecated(since="11.1")
    public Schema getSchemaFromURI(String schemaURI) {
        return this.schemas.values().stream().filter(schema -> schema.getNamespace().uri.equals(schemaURI)).findFirst().orElse(null);
    }

    protected void computeFacets(List<FacetDescriptor> allFacets) {
        this.facets.clear();
        this.noPerDocumentQueryFacets.clear();
        for (FacetDescriptor fd : allFacets) {
            Set<String> fdSchemas = SchemaDescriptor.getSchemaNames(fd.schemas);
            this.registerFacet(fd.name, fdSchemas);
            if (!Boolean.FALSE.equals(fd.perDocumentQuery)) continue;
            this.noPerDocumentQueryFacets.add(fd.name);
        }
    }

    protected CompositeType registerFacet(String name, Set<String> schemaNames) {
        ArrayList<Schema> facetSchemas = new ArrayList<Schema>(schemaNames.size());
        for (String schemaName : schemaNames) {
            Schema schema = this.schemas.get(schemaName);
            if (schema == null) {
                if (this.disabledSchemas.contains(schemaName)) {
                    log.debug("Facet: {} uses disabled schema: {}", (Object)name, (Object)schemaName);
                    continue;
                }
                log.error("Facet: {} uses unknown schema: {}", (Object)name, (Object)schemaName);
                continue;
            }
            facetSchemas.add(schema);
        }
        CompositeTypeImpl ct = new CompositeTypeImpl(null, "@facets", name, facetSchemas);
        this.facets.put(name, ct);
        return ct;
    }

    @Override
    public CompositeType[] getFacets() {
        return new ArrayList<CompositeType>(this.facets.values()).toArray(new CompositeType[this.facets.size()]);
    }

    @Override
    public CompositeType getFacet(String name) {
        return this.facets.get(name);
    }

    @Override
    public Set<String> getNoPerDocumentQueryFacets() {
        return Collections.unmodifiableSet(this.noPerDocumentQueryFacets);
    }

    protected void computeDocumentTypes(Map<String, DocumentTypeDescriptor> dtds) {
        this.documentTypes.clear();
        this.documentTypesExtending.clear();
        this.registerDocumentType(new DocumentTypeImpl("Document"));
        for (String string : dtds.keySet()) {
            LinkedHashSet<String> stack = new LinkedHashSet<String>();
            this.recomputeDocumentType(string, stack, dtds);
        }
        this.documentTypesForFacet.clear();
        for (DocumentType documentType : this.documentTypes.values()) {
            for (String facet : documentType.getFacets()) {
                this.documentTypesForFacet.computeIfAbsent(facet, k -> new HashSet()).add(documentType.getName());
            }
        }
        this.specialDocumentTypes = dtds.values().stream().filter(d -> Boolean.TRUE.equals(d.special)).map(d -> d.name).collect(Collectors.toSet());
    }

    protected DocumentType recomputeDocumentType(String name, Set<String> stack, Map<String, DocumentTypeDescriptor> dtds) {
        DocumentType parent;
        DocumentTypeImpl docType = this.documentTypes.get(name);
        if (docType != null) {
            return docType;
        }
        if (stack.contains(name)) {
            log.error("Document type: {} used in parent inheritance loop: {}", (Object)name, stack);
            return null;
        }
        DocumentTypeDescriptor dtd = dtds.get(name);
        if (dtd == null) {
            log.error("Document type: {} does not exist, used as parent by type: {}", (Object)name, stack);
            return null;
        }
        String parentName = dtd.superTypeName;
        if (parentName == null) {
            parent = null;
        } else {
            parent = this.documentTypes.get(parentName);
            if (parent == null) {
                stack.add(name);
                parent = this.recomputeDocumentType(parentName, stack, dtds);
                stack.remove(name);
            }
        }
        for (Type p = parent; p != null; p = p.getSuperType()) {
            Set<String> set = this.documentTypesExtending.get(p.getName());
            set.add(name);
        }
        return this.recomputeDocumentType(name, dtd, parent);
    }

    protected DocumentType recomputeDocumentType(String name, DocumentTypeDescriptor dtd, DocumentType parent) {
        HashSet<String> facetNames = new HashSet<String>(Arrays.asList(dtd.facets));
        Set<String> schemaNames = SchemaDescriptor.getSchemaNames(dtd.schemas);
        HashSet<String> subtypes = new HashSet<String>(Arrays.asList(dtd.subtypes));
        HashSet<String> forbidden = new HashSet<String>(Arrays.asList(dtd.forbiddenSubtypes));
        if (parent != null) {
            facetNames.addAll(parent.getFacets());
            schemaNames.addAll(Arrays.asList(parent.getSchemaNames()));
        }
        for (String string : facetNames) {
            CompositeType ct = this.facets.get(string);
            if (ct == null) {
                if (this.disabledFacets.contains(string)) {
                    log.debug("Disabled facet: {} used in document type: {}", (Object)string, (Object)name);
                    continue;
                }
                log.warn("Undeclared facet: {} used in document type: {}", (Object)string, (Object)name);
                ct = this.registerFacet(string, Collections.emptySet());
            }
            schemaNames.addAll(Arrays.asList(ct.getSchemaNames()));
        }
        facetNames.removeAll(this.disabledFacets);
        ArrayList<Schema> docTypeSchemas = new ArrayList<Schema>();
        for (String schemaName : schemaNames) {
            Schema schema = this.schemas.get(schemaName);
            if (schema == null) {
                if (this.disabledSchemas.contains(schemaName)) {
                    log.debug("Document type: {} uses disabled schema: {}", (Object)name, (Object)schemaName);
                    continue;
                }
                log.error("Document type: {} uses unknown schema: {}", (Object)name, (Object)schemaName);
                continue;
            }
            docTypeSchemas.add(schema);
        }
        PrefetchInfo prefetchInfo = dtd.prefetch == null ? this.prefetchInfo : new PrefetchInfo(dtd.prefetch);
        DocumentTypeImpl docType = new DocumentTypeImpl(name, parent, docTypeSchemas, facetNames, prefetchInfo);
        docType.setSubtypes(subtypes);
        docType.setForbiddenSubtypes(forbidden);
        this.registerDocumentType(docType);
        return docType;
    }

    protected void registerDocumentType(DocumentTypeImpl docType) {
        String name = docType.getName();
        this.documentTypes.put(name, docType);
        this.documentTypesExtending.put(name, new HashSet<String>(Collections.singleton(name)));
    }

    @Override
    public DocumentType getDocumentType(String name) {
        return this.documentTypes.get(name);
    }

    @Override
    public Set<String> getDocumentTypeNamesForFacet(String facet) {
        return this.documentTypesForFacet.get(facet);
    }

    @Override
    public Set<String> getDocumentTypeNamesExtending(String docTypeName) {
        return this.documentTypesExtending.get(docTypeName);
    }

    @Override
    public DocumentType[] getDocumentTypes() {
        return new ArrayList<DocumentTypeImpl>(this.documentTypes.values()).toArray(new DocumentType[0]);
    }

    @Override
    public int getDocumentTypesCount() {
        return this.documentTypes.size();
    }

    @Override
    public boolean hasSuperType(String docType, String superType) {
        if (docType == null || superType == null) {
            return false;
        }
        Set<String> subTypes = this.getDocumentTypeNamesExtending(superType);
        return subTypes != null && subTypes.contains(docType);
    }

    @Override
    public Set<String> getAllowedSubTypes(String typeName) {
        DocumentType dt = this.getDocumentType(typeName);
        return dt == null ? null : dt.getAllowedSubtypes();
    }

    protected void computeProxies(List<ProxiesDescriptor> proxies) {
        for (ProxiesDescriptor pd : proxies) {
            if (!"*".equals(pd.getType())) {
                log.error("Proxy descriptor for specific type not supported: {}", (Object)pd);
                continue;
            }
            for (String schemaName : pd.getSchemas()) {
                if (this.proxySchemaNames.contains(schemaName)) continue;
                Schema schema = this.schemas.get(schemaName);
                if (schema == null) {
                    log.error("Proxy schema uses unknown schema: {}", (Object)schemaName);
                    continue;
                }
                this.proxySchemas.add(schema);
                this.proxySchemaNames.add(schemaName);
            }
        }
    }

    @Override
    public List<Schema> getProxySchemas(String docType) {
        return new ArrayList<Schema>(this.proxySchemas);
    }

    @Override
    public boolean isProxySchema(String schema, String docType) {
        return this.proxySchemaNames.contains(schema);
    }

    @Override
    public Field getField(String xpath) {
        Field field = null;
        if (xpath != null && xpath.contains("/")) {
            String[] properties = xpath.split("/");
            Field resolvedField = this.getField(properties[0]);
            for (int x = 1; x < properties.length && resolvedField != null; ++x) {
                resolvedField = this.getField(resolvedField, properties[x], x == properties.length - 1);
            }
            if (resolvedField != null) {
                field = resolvedField;
            }
        } else {
            field = this.fields.get(xpath);
            if (field == null) {
                QName qname = QName.valueOf(xpath);
                String prefix = qname.getPrefix();
                Schema schema = this.getSchemaFromPrefix(prefix);
                if (schema == null) {
                    schema = this.getSchema(prefix);
                }
                if (schema != null && (field = schema.getField(qname.getLocalName())) != null) {
                    this.fields.put(xpath, field);
                }
            }
        }
        return field;
    }

    @Override
    public Field getField(Field parent, String subFieldName) {
        return this.getField(parent, subFieldName, true);
    }

    protected Field getField(Field parent, String subFieldName, boolean finalCall) {
        if (parent != null) {
            Type type = parent.getType();
            if (type.isListType()) {
                ListType listType = (ListType)type;
                if ("*".equals(subFieldName)) {
                    if (!finalCall) {
                        return parent;
                    }
                    return this.resolveSubField(listType, null, true);
                }
                try {
                    Integer.valueOf(subFieldName);
                    if (!finalCall) {
                        return parent;
                    }
                    return this.resolveSubField(listType, null, true);
                }
                catch (NumberFormatException e) {
                    return this.resolveSubField(listType, subFieldName, false);
                }
            }
            if (type.isComplexType()) {
                return ((ComplexType)type).getField(subFieldName);
            }
        }
        return null;
    }

    protected Field resolveSubField(ListType listType, String subName, boolean fallbackOnSubElement) {
        Type itemType = listType.getFieldType();
        if (itemType.isComplexType() && subName != null) {
            ComplexType complexType = (ComplexType)itemType;
            return complexType.getField(subName);
        }
        if (fallbackOnSubElement) {
            return listType.getField();
        }
        return null;
    }

    @Override
    @Deprecated(since="11.1")
    public PropertyDeprecationHandler getDeprecatedProperties() {
        return new PropertyDeprecationHandler(this.deprecatedProperties);
    }

    @Override
    @Deprecated(since="11.1")
    public PropertyDeprecationHandler getRemovedProperties() {
        return new PropertyDeprecationHandler(this.removedProperties);
    }

    @Override
    public boolean getClearComplexPropertyBeforeSet() {
        return this.clearComplexPropertyBeforeSet;
    }

    @Override
    public boolean getAllowVersionWriteForDublinCore() {
        return this.allowVersionWriteForDublinCore;
    }

    protected synchronized void computePropertyCharacteristics(List<PropertyDescriptor> descriptors) {
        this.propertyCharacteristics = descriptors.stream().collect(Collectors.groupingBy(PropertyDescriptor::getSchema, Collectors.toMap(PropertyDescriptor::getName, Function.identity())));
        this.deprecatedProperties = descriptors.stream().filter(PropertyDescriptor::isDeprecated).collect(Collectors.groupingBy(PropertyDescriptor::getSchema, Collector.of(HashMap::new, (m, d) -> m.put(d.name, d.fallback), (m1, m2) -> {
            m1.putAll(m2);
            return m1;
        }, new Collector.Characteristics[0])));
        this.removedProperties = descriptors.stream().filter(PropertyDescriptor::isRemoved).collect(Collectors.groupingBy(PropertyDescriptor::getSchema, Collector.of(HashMap::new, (m, d) -> m.put(d.name, d.fallback), (m1, m2) -> {
            m1.putAll(m2);
            return m1;
        }, new Collector.Characteristics[0])));
    }

    @Override
    public boolean isSecured(String schema, String path) {
        return this.checkPropertyCharacteristic(schema, path, PropertyDescriptor::isSecured);
    }

    @Override
    public boolean isDeprecated(String schema, String path) {
        return this.checkPropertyCharacteristic(schema, path, PropertyDescriptor::isDeprecated);
    }

    @Override
    public boolean isRemoved(String schema, String path) {
        return this.checkPropertyCharacteristic(schema, path, PropertyDescriptor::isRemoved);
    }

    @Override
    public Set<String> getDeprecatedProperties(String schema) {
        return this.getPropertyCharacteristics(schema, PropertyDescriptor::isDeprecated, PropertyDescriptor::getName);
    }

    @Override
    public Set<String> getRemovedProperties(String schema) {
        return this.getPropertyCharacteristics(schema, PropertyDescriptor::isRemoved, PropertyDescriptor::getName);
    }

    protected <R> Set<R> getPropertyCharacteristics(String schema, Predicate<PropertyDescriptor> predicate, Function<PropertyDescriptor, R> function) {
        return this.propertyCharacteristics.getOrDefault(schema, Map.of()).values().stream().filter(predicate).map(function).collect(Collectors.toSet());
    }

    @Override
    public Optional<String> getFallback(String schema, String path) {
        return Optional.ofNullable(this.propertyCharacteristics.get(schema)).map(props -> (PropertyDescriptor)props.get(this.cleanPath(path))).map(PropertyDescriptor::getFallback);
    }

    protected boolean checkPropertyCharacteristic(String schema, String path, Predicate<PropertyDescriptor> predicate) {
        Map properties = this.propertyCharacteristics.getOrDefault(schema, Map.of());
        return !properties.isEmpty() && Stream.iterate(this.cleanPath(path), StringUtils::isNotBlank, key -> key.substring(0, Math.max(key.lastIndexOf(47), 0))).anyMatch(p -> properties.containsKey(p) && predicate.test((PropertyDescriptor)properties.get(p)));
    }

    protected String cleanPath(String path) {
        return path.substring(path.lastIndexOf(58) + 1).replaceAll("/-?\\d+/", "/*/");
    }

    @Override
    public Set<String> getSpecialDocumentTypes() {
        return Collections.unmodifiableSet(this.specialDocumentTypes);
    }
}

