/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.nuxeo.ecm.core.schema.PropertyDescriptor;
import org.nuxeo.ecm.core.schema.SchemaBindingDescriptor;
import org.nuxeo.ecm.core.schema.SchemaBindingRegistry;
import org.w3c.dom.Element;

public class SchemaRegistry
implements Registry {
    protected SchemaBindingRegistry schemaBindingRegistry = new SchemaBindingRegistry();
    protected MapRegistry propertyRegistry = new MapRegistry();

    public void initialize() {
        this.schemaBindingRegistry.initialize();
        this.propertyRegistry.initialize();
    }

    public void tag(String id) {
        this.schemaBindingRegistry.tag(id);
        this.propertyRegistry.tag(id);
    }

    public boolean isTagged(String id) {
        return this.schemaBindingRegistry.isTagged(id) || this.propertyRegistry.isTagged(id);
    }

    public void register(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        Class klass = xObject.getKlass();
        if (SchemaBindingDescriptor.class.equals((Object)klass)) {
            this.schemaBindingRegistry.register(ctx, xObject, element, tag);
        } else if (PropertyDescriptor.class.equals((Object)klass)) {
            this.propertyRegistry.register(ctx, xObject, element, tag);
        } else {
            throw new IllegalArgumentException("Unsupported class " + klass);
        }
    }

    public void unregister(String tag) {
        this.schemaBindingRegistry.unregister(tag);
        this.propertyRegistry.unregister(tag);
    }

    public Map<String, SchemaBindingDescriptor> getSchemas() {
        return this.schemaBindingRegistry.getContributions();
    }

    public Set<String> getDisabledSchemas() {
        return this.schemaBindingRegistry.getDisabledContributions();
    }

    public List<PropertyDescriptor> getProperties() {
        return this.propertyRegistry.getContributionValues();
    }
}

