/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.primitives;

import java.util.Calendar;
import java.util.Date;
import org.nuxeo.ecm.core.schema.types.PrimitiveType;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;
import org.nuxeo.ecm.core.schema.types.constraints.DateIntervalConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.NotNullConstraint;
import org.nuxeo.ecm.core.schema.utils.DateParser;

public class DateType
extends PrimitiveType {
    private static final long serialVersionUID = 1L;
    public static final String ID = "date";
    public static final DateType INSTANCE = new DateType();

    public DateType() {
        super(ID);
    }

    @Override
    public boolean validate(Object object) {
        return object instanceof Date || object instanceof Calendar;
    }

    @Override
    public Object convert(Object value) {
        if (value instanceof Date) {
            return value;
        }
        if (value instanceof Calendar) {
            return value;
        }
        try {
            return Integer.valueOf((String)value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Object decode(String str) {
        Date date = DateParser.parseW3CDateTime(str);
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        return null;
    }

    @Override
    public String encode(Object object) {
        if (object instanceof Date) {
            return DateParser.formatW3CDateTime((Date)object);
        }
        if (object instanceof Calendar) {
            return DateParser.formatW3CDateTime(((Calendar)object).getTime());
        }
        return null;
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public boolean support(Class<? extends Constraint> constraint) {
        if (NotNullConstraint.class.equals(constraint)) {
            return true;
        }
        return DateIntervalConstraint.class.equals(constraint);
    }
}

