/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="rule")
public class FilterRule {
    @XNode(value="@grant")
    boolean grant = false;
    @XNodeList(value="permission", type=String[].class, componentType=String.class)
    String[] permissions;
    @XNodeList(value="facet", type=String[].class, componentType=String.class)
    String[] facets;
    @XNodeList(value="type", type=String[].class, componentType=String.class)
    String[] types;
    @XNodeList(value="schema", type=String[].class, componentType=String.class)
    String[] schemas;
    @XNodeList(value="group", type=String[].class, componentType=String.class)
    String[] groups;
    String[] conditions;
    protected String cacheKey;

    public FilterRule() {
    }

    public FilterRule(boolean grant, String[] permissions, String[] facets, String[] conditions, String[] types, String[] schemas) {
        this.grant = grant;
        this.permissions = permissions;
        this.facets = facets;
        this.conditions = conditions;
        this.types = types;
        this.schemas = schemas;
    }

    @XNodeList(value="condition", type=String[].class, componentType=String.class)
    public void setConditions(String[] conditions) {
        this.conditions = conditions;
    }

    public String getCacheKey() {
        if (this.cacheKey == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("grant:");
            sb.append(this.grant);
            if (this.permissions != null && this.permissions.length > 0) {
                sb.append(":permissions:");
                for (String perm : this.permissions) {
                    sb.append(perm);
                    sb.append(",");
                }
            }
            if (this.facets != null && this.facets.length > 0) {
                sb.append(":facets:");
                for (String facet : this.facets) {
                    sb.append(facet);
                    sb.append(",");
                }
            }
            if (this.conditions != null && this.conditions.length > 0) {
                sb.append(":conditions:");
                for (String cond : this.conditions) {
                    sb.append(cond);
                    sb.append(",");
                }
            }
            if (this.types != null && this.types.length > 0) {
                sb.append(":types:");
                for (String typ : this.types) {
                    sb.append(typ);
                    sb.append(",");
                }
            }
            if (this.schemas != null && this.schemas.length > 0) {
                sb.append(":schemas:");
                for (String schem : this.schemas) {
                    sb.append(schem);
                    sb.append(",");
                }
            }
            if (this.groups != null && this.groups.length > 0) {
                sb.append(":groups:");
                for (String group : this.groups) {
                    sb.append(group);
                    sb.append(",");
                }
            }
            this.cacheKey = sb.toString();
        }
        return this.cacheKey;
    }

    public String toString() {
        return this.getCacheKey();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FilterRule)) {
            return false;
        }
        return this.getCacheKey().equals(((FilterRule)obj).getCacheKey());
    }

    public int hashCode() {
        return this.getCacheKey().hashCode();
    }
}

