/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.adapters;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.jaxrs.io.operations.ExecutionRequest;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.jaxrs.ResponseHelper;
import org.nuxeo.ecm.automation.server.jaxrs.RestOperationException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="op", type="OperationService")
@Produces(value={"application/json", "application/json+esentity"})
public class OperationAdapter
extends DefaultAdapter {
    public static final String NAME = "op";

    @POST
    @Path(value="{operationName}")
    public Response doPost(@PathParam(value="operationName") String oid, @Context HttpServletRequest request, @Context HttpServletResponse response, ExecutionRequest xreq) {
        try {
            AutomationServer srv = (AutomationServer)Framework.getService(AutomationServer.class);
            if (!srv.accept(oid, false, request)) {
                return ResponseHelper.notFound();
            }
            AutomationService service = (AutomationService)Framework.getService(AutomationService.class);
            OperationType operationType = service.getOperation(oid);
            if (operationType instanceof ChainTypeImpl) {
                OperationChain chain = ((ChainTypeImpl)operationType).getChain();
                if (!chain.getOperations().isEmpty()) {
                    operationType = service.getOperation(((OperationParameters)chain.getOperations().get(0)).id());
                } else {
                    throw new NuxeoException("Chain '" + oid + "' doesn't contain any operation");
                }
            }
            for (InvokableMethod method : operationType.getMethods()) {
                if (this.getTarget().getAdapter(method.getInputType()) == null) continue;
                xreq.setInput(this.getTarget().getAdapter(method.getInputType()));
                break;
            }
            OperationContext ctx = xreq.createContext(request, response, this.getContext().getCoreSession());
            Object result = service.run(ctx, oid, xreq.getParams());
            int customHttpStatus = xreq.getRestOperationContext().getHttpStatus();
            return Response.status((int)customHttpStatus).entity(result).build();
        }
        catch (OperationException cause) {
            if (ExceptionHelper.unwrapException((Throwable)cause) instanceof RestOperationException) {
                int customHttpStatus = ((RestOperationException)ExceptionHelper.unwrapException((Throwable)cause)).getStatus();
                throw new NuxeoException("Failed to invoke operation: " + oid, (Throwable)cause, customHttpStatus);
            }
            throw new NuxeoException("Failed to invoke operation: " + oid, (Throwable)cause);
        }
    }
}

