/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.enrichers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.restapi.server.jaxrs.adapters.AuditAdapter;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class AuditJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "audit";

    public AuditJsonEnricher() {
        super(NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        jg.writeFieldName(NAME);
        jg.writeStartArray();
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            DocumentModel searchDocument = wrapper.getSession().createDocumentModel("BasicAuditSearch");
            searchDocument.setPropertyValue("bas:eventIds", (Serializable)((Object)this.ctx.getParameters("eventId")));
            searchDocument.setPropertyValue("bas:eventCategories", (Serializable)((Object)this.ctx.getParameters("category")));
            searchDocument.setPropertyValue("bas:principalNames", (Serializable)((Object)this.ctx.getParameters("principalName")));
            searchDocument.setPropertyValue("bas:startDate", (Serializable)AuditAdapter.getCalendarParameter((String)this.ctx.getParameter("startEventDate")));
            searchDocument.setPropertyValue("bas:endDate", (Serializable)AuditAdapter.getCalendarParameter((String)this.ctx.getParameter("endEventDate")));
            PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
            PageProviderDefinition ppDefinition = ppService.getPageProviderDefinition("DOCUMENT_HISTORY_PROVIDER");
            HashMap<String, Serializable> props = new HashMap<String, Serializable>();
            props.put("coreSession", (Serializable)wrapper.getSession());
            PageProvider pp = ppService.getPageProvider("", ppDefinition, searchDocument, null, null, Long.valueOf(0L), props, new Object[]{document});
            for (LogEntry e : pp.getCurrentPage()) {
                this.writeEntity(e, jg);
            }
        }
        finally {
            jg.writeEndArray();
        }
    }
}

