/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.management;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.management.api.ProbeInfo;
import org.nuxeo.ecm.core.management.api.ProbeManager;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="management/probes")
@Produces(value={"application/json"})
public class ProbesObject
extends AbstractResource<ResourceTypeImpl> {
    @GET
    @Path(value="{probeName}")
    public ProbeInfo doGet(@PathParam(value="probeName") String probeName) {
        ProbeInfo probeInfo = ((ProbeManager)Framework.getService(ProbeManager.class)).getProbeInfo(probeName);
        return this.checkProbe(probeName, probeInfo);
    }

    @GET
    public List<ProbeInfo> doGet() {
        return new ArrayList<ProbeInfo>(((ProbeManager)Framework.getService(ProbeManager.class)).getAllProbeInfos());
    }

    @POST
    @Path(value="{probeName}")
    public ProbeInfo launch(@PathParam(value="probeName") String probeName) {
        ProbeInfo probeInfo = ((ProbeManager)Framework.getService(ProbeManager.class)).runProbe(probeName);
        return this.checkProbe(probeName, probeInfo);
    }

    protected ProbeInfo checkProbe(String probeName, ProbeInfo probeInfo) {
        if (probeInfo == null) {
            throw new NuxeoException("No such probe: " + probeName, 404);
        }
        return probeInfo;
    }
}

