/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.usermanager;

import java.util.ArrayList;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.restapi.server.jaxrs.usermanager.GroupRootObject;
import org.nuxeo.ecm.restapi.server.jaxrs.usermanager.UserRootObject;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="userToGroup")
public class UserToGroupObject
extends DefaultObject {
    private NuxeoGroup group;
    private NuxeoPrincipal principal;

    protected void initialize(Object ... args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("UserToGroup object takes two parameters");
        }
        this.principal = (NuxeoPrincipal)args[0];
        this.group = (NuxeoGroup)args[1];
    }

    @POST
    public Response doAddUserToGroup() {
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        this.checkPrincipalCanAdministerGroupAndUser(um);
        this.addUserToGroup(this.principal, this.group);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)um.getPrincipal(this.principal.getName())).build();
    }

    private void checkPrincipalCanAdministerGroupAndUser(UserManager um) {
        NuxeoPrincipal currentPrincipal = this.getContext().getCoreSession().getPrincipal();
        if (!(currentPrincipal.isAdministrator() || currentPrincipal.isMemberOf("powerusers") && UserRootObject.isAPowerUserEditableUser(this.principal) && GroupRootObject.isAPowerUserEditableGroup(this.group))) {
            throw new WebSecurityException("Cannot edit user");
        }
    }

    @DELETE
    public Response doRemoveUserFromGroup() {
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        this.checkPrincipalCanAdministerGroupAndUser(um);
        this.removeUserFromGroup(this.principal, this.group);
        return Response.ok((Object)this.principal.getName()).build();
    }

    protected void addUserToGroup(NuxeoPrincipal principal, NuxeoGroup group) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        if (!BaseSession.isReadOnlyEntry((DocumentModel)principal.getModel())) {
            String groupName;
            ArrayList<String> groups = principal.getGroups();
            if (groups == null) {
                groups = new ArrayList<String>();
            }
            if (!groups.contains(groupName = group.getName())) {
                groups.add(groupName);
                principal.setGroups(groups);
                userManager.updateUser(principal.getModel());
            }
        } else {
            String userName;
            ArrayList<String> users = group.getMemberUsers();
            if (users == null) {
                users = new ArrayList<String>();
            }
            if (!users.contains(userName = principal.getName())) {
                users.add(userName);
                group.setMemberUsers(users);
                userManager.updateGroup(group.getModel());
            }
        }
    }

    protected void removeUserFromGroup(NuxeoPrincipal principal, NuxeoGroup group) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        if (!BaseSession.isReadOnlyEntry((DocumentModel)principal.getModel())) {
            String groupName;
            ArrayList groups = principal.getGroups();
            if (groups == null) {
                groups = new ArrayList();
            }
            if (groups.contains(groupName = group.getName())) {
                groups.remove(groupName);
                principal.setGroups(groups);
                userManager.updateUser(principal.getModel());
            }
        } else {
            String userName;
            ArrayList users = group.getMemberUsers();
            if (users == null) {
                users = new ArrayList();
            }
            if (users.contains(userName = principal.getName())) {
                users.remove(userName);
                group.setMemberUsers(users);
                userManager.updateGroup(group.getModel());
            }
        }
    }
}

