/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.computedgroups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.platform.computedgroups.ComputedGroupsService;
import org.nuxeo.ecm.platform.computedgroups.GroupComputer;
import org.nuxeo.ecm.platform.computedgroups.GroupComputerChainDescriptor;
import org.nuxeo.ecm.platform.computedgroups.GroupComputerDescriptor;
import org.nuxeo.ecm.platform.computedgroups.GroupComputerLabelled;
import org.nuxeo.ecm.platform.computedgroups.NuxeoComputedGroup;
import org.nuxeo.ecm.platform.usermanager.GroupConfig;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class ComputedGroupsServiceImpl
extends DefaultComponent
implements ComputedGroupsService {
    public static final String COMPUTER_EP = "computer";
    public static final String CHAIN_EP = "computerChain";
    protected Map<String, GroupComputer> computers;
    protected List<String> computerNames;
    protected boolean allowOverride = true;

    public void start(ComponentContext context) {
        this.computers = this.getRegistryContributions(COMPUTER_EP).stream().collect(Collectors.toConcurrentMap(GroupComputerDescriptor::getName, GroupComputerDescriptor::getComputer));
        this.computerNames = this.getRegistryContribution(CHAIN_EP).map(GroupComputerChainDescriptor::getComputerNames).orElse(Collections.emptyList());
        List missingComputers = this.computerNames.stream().filter(Predicate.not(this.computers::containsKey)).collect(Collectors.toList());
        if (!missingComputers.isEmpty()) {
            this.addRuntimeMessage(RuntimeMessage.Level.ERROR, String.format("Missing group computers: %s", missingComputers));
        }
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.computers = null;
        this.computerNames = null;
    }

    @Override
    public List<String> computeGroupsForUser(NuxeoPrincipalImpl nuxeoPrincipal) {
        ArrayList<String> userGroups = new ArrayList<String>();
        for (String computerName : this.computerNames) {
            userGroups.addAll(this.computers.get(computerName).getGroupsForUser(nuxeoPrincipal));
        }
        return userGroups;
    }

    @Override
    public void updateGroupsForUser(NuxeoPrincipalImpl nuxeoPrincipal) {
        List<String> computedGroups = this.computeGroupsForUser(nuxeoPrincipal);
        HashSet<String> virtualGroups = new HashSet<String>(nuxeoPrincipal.getVirtualGroups());
        virtualGroups.addAll(computedGroups);
        nuxeoPrincipal.setVirtualGroups(new ArrayList<String>(virtualGroups));
    }

    @Override
    public boolean allowGroupOverride() {
        return this.allowOverride;
    }

    @Override
    @Deprecated
    public NuxeoGroup getComputedGroup(String groupName) {
        return this.getComputedGroup(groupName, GroupConfig.DEFAULT);
    }

    @Override
    public NuxeoGroup getComputedGroup(String groupName, GroupConfig groupConfig) {
        for (String name : this.computerNames) {
            GroupComputer computer = this.computers.get(name);
            if (!computer.hasGroup(groupName)) continue;
            if (computer instanceof GroupComputerLabelled) {
                String groupLabel = ((GroupComputerLabelled)computer).getLabel(groupName);
                return new NuxeoComputedGroup(groupName, groupLabel, groupConfig);
            }
            return new NuxeoComputedGroup(groupName, groupConfig);
        }
        return null;
    }

    @Override
    public List<String> computeGroupIds() {
        ArrayList<String> groupIds = new ArrayList<String>();
        for (String name : this.computerNames) {
            List<String> foundGroupIds = this.computers.get(name).getAllGroupIds();
            if (foundGroupIds == null) continue;
            groupIds.addAll(foundGroupIds);
        }
        return groupIds;
    }

    @Override
    public List<String> getComputedGroupMembers(String groupName) {
        ArrayList<String> members = new ArrayList<String>();
        for (String name : this.computerNames) {
            List<String> foundMembers = this.computers.get(name).getGroupMembers(groupName);
            if (foundMembers == null) continue;
            members.addAll(foundMembers);
        }
        return members;
    }

    @Override
    public List<String> getComputedGroupParent(String groupName) {
        ArrayList<String> parents = new ArrayList<String>();
        for (String name : this.computerNames) {
            List<String> foundParents = this.computers.get(name).getParentsGroupNames(groupName);
            if (foundParents == null) continue;
            parents.addAll(foundParents);
        }
        return parents;
    }

    @Override
    public List<String> getComputedGroupSubGroups(String groupName) {
        ArrayList<String> subGroups = new ArrayList<String>();
        for (String name : this.computerNames) {
            List<String> foundSubGroups = this.computers.get(name).getSubGroupsNames(groupName);
            if (foundSubGroups == null) continue;
            subGroups.addAll(foundSubGroups);
        }
        return subGroups;
    }

    public List<GroupComputerDescriptor> getComputerDescriptors() {
        return this.getRegistryContributions(COMPUTER_EP);
    }

    @Override
    public boolean activateComputedGroups() {
        return !this.computerNames.isEmpty();
    }

    @Override
    public List<String> searchComputedGroups(Map<String, Serializable> filter, Set<String> fulltext) {
        ArrayList<String> foundGroups = new ArrayList<String>();
        for (String name : this.computerNames) {
            foundGroups.addAll(this.computers.get(name).searchGroups(filter, fulltext));
        }
        Collections.sort(foundGroups);
        return foundGroups;
    }

    @Override
    public List<String> searchComputedGroups(QueryBuilder queryBuilder) {
        ArrayList<String> groups = new ArrayList<String>();
        for (String name : this.computerNames) {
            groups.addAll(this.computers.get(name).searchGroups(queryBuilder));
        }
        Collections.sort(groups);
        return groups;
    }
}

