/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.usermanager.UserAdapter;
import org.nuxeo.ecm.platform.usermanager.UserConfig;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.UserManagerImpl;

public class UserAdapterImpl
implements UserAdapter {
    private static final Log log = LogFactory.getLog(UserAdapterImpl.class);
    protected final DocumentModel doc;
    protected final UserConfig userConfig;
    private DataModel dataModel;

    public UserAdapterImpl(DocumentModel doc, UserManager userManager) {
        this.doc = doc;
        this.userConfig = userManager != null && userManager instanceof UserManagerImpl ? ((UserManagerImpl)userManager).userConfig : UserConfig.DEFAULT;
        this.dataModel = doc.getDataModel(this.userConfig.schemaName);
    }

    @Override
    public String getName() {
        return (String)this.dataModel.getValue(this.userConfig.nameKey);
    }

    @Override
    public String getFirstName() {
        return (String)this.dataModel.getValue(this.userConfig.firstNameKey);
    }

    @Override
    public String getLastName() {
        return (String)this.dataModel.getValue(this.userConfig.lastNameKey);
    }

    @Override
    public String getEmail() {
        return (String)this.dataModel.getValue(this.userConfig.emailKey);
    }

    @Override
    public String getCompany() {
        return (String)this.dataModel.getValue(this.userConfig.companyKey);
    }

    @Override
    public List<String> getGroups() {
        return (List)this.dataModel.getValue(this.userConfig.groupsKey);
    }

    @Override
    public String getTenantId() {
        return (String)this.dataModel.getValue(this.userConfig.tenantIdKey);
    }

    @Override
    public String getSchemaName() {
        return this.userConfig.schemaName;
    }
}

