/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.chronicle;

import java.io.Externalizable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.log.LogOffset;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogTailer;

public class ChronicleCompoundLogTailer<M extends Externalizable>
implements LogTailer<M> {
    protected final List<ChronicleLogTailer<M>> tailers = new ArrayList<ChronicleLogTailer<M>>();
    protected final Name group;
    protected final int size;
    protected final List<LogPartition> logPartitions = new ArrayList<LogPartition>();
    protected final Codec<M> codec;
    protected boolean closed;
    protected long counter;

    public ChronicleCompoundLogTailer(Collection<ChronicleLogTailer<M>> tailers, Name group) {
        this.tailers.addAll(tailers);
        this.group = group;
        this.size = tailers.size();
        this.codec = tailers.isEmpty() ? null : tailers.iterator().next().getCodec();
        tailers.forEach(partition -> this.logPartitions.addAll(partition.assignments()));
    }

    @Override
    public LogRecord<M> read(Duration timeout) throws InterruptedException {
        LogRecord<M> ret = this.read();
        if (ret != null) {
            return ret;
        }
        long timeoutMs = timeout.toMillis();
        long deadline = System.currentTimeMillis() + timeoutMs;
        long delay = Math.min(100L, timeoutMs);
        while (ret == null && System.currentTimeMillis() < deadline) {
            Thread.sleep(delay);
            ret = this.read();
        }
        return ret;
    }

    protected LogRecord<M> read() {
        if (this.size <= 0) {
            return null;
        }
        long end = this.counter + (long)this.size;
        do {
            ++this.counter;
            int i = (int)this.counter % this.size;
            LogRecord<M> ret = this.tailers.get(i).read();
            if (ret == null) continue;
            return ret;
        } while (this.counter < end);
        return null;
    }

    @Override
    public LogOffset commit(LogPartition partition) {
        for (LogTailer logTailer : this.tailers) {
            if (!logTailer.assignments().contains(partition)) continue;
            return logTailer.commit(partition);
        }
        throw new IllegalArgumentException("No tailer matching: " + partition);
    }

    @Override
    public void commit() {
        this.tailers.forEach(LogTailer::commit);
    }

    @Override
    public void toEnd() {
        this.tailers.forEach(ChronicleLogTailer::toEnd);
    }

    @Override
    public void toStart() {
        this.tailers.forEach(ChronicleLogTailer::toStart);
    }

    @Override
    public void toLastCommitted() {
        this.tailers.forEach(ChronicleLogTailer::toLastCommitted);
    }

    @Override
    public Collection<LogPartition> assignments() {
        return this.logPartitions;
    }

    @Override
    public Name group() {
        return this.group;
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    @Override
    public Codec<M> getCodec() {
        return this.codec;
    }

    @Override
    public void seek(LogOffset offset) {
        for (LogTailer logTailer : this.tailers) {
            if (!logTailer.assignments().contains(offset.partition())) continue;
            logTailer.seek(offset);
            return;
        }
        throw new IllegalStateException("Cannot seek, tailer " + this + " has no assignment for partition: " + offset);
    }

    @Override
    public LogOffset offsetForTimestamp(LogPartition partition, long timestamp) {
        throw new UnsupportedOperationException("ChronicleLog does not support seek by timestamp");
    }

    @Override
    public void reset() {
        this.tailers.forEach(ChronicleLogTailer::reset);
    }

    @Override
    public void reset(LogPartition partition) {
        ChronicleLogTailer tailer = this.tailers.stream().filter(t -> t.assignments().contains(partition)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot reset, partition: %s not found on tailer assignments: %s", partition, this.logPartitions)));
        tailer.reset();
    }

    @Override
    public void close() {
        for (ChronicleLogTailer<M> tailer : this.tailers) {
            tailer.close();
        }
        this.closed = true;
    }
}

