/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mimetype.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicException;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.MagicMatchNotFoundException;
import net.sf.jmimemagic.MagicParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.mimetype.service.ExtensionDescriptor;
import org.nuxeo.ecm.platform.mimetype.service.MimetypeDescriptorRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class MimetypeRegistryService
extends DefaultComponent
implements MimetypeRegistry {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.mimetype.service.MimetypeRegistryService");
    protected static final String MIMETYPE_XP = "mimetype";
    protected static final String EXTENSION_XP = "extension";
    public static final long MAX_SIZE_FOR_SCAN = 0xA00000L;
    public static final String TMP_EXTENSION = "tmp";
    public static final String MSOFFICE_TMP_PREFIX = "~$";

    protected MimetypeDescriptorRegistry getMimetypeRegistry() {
        return (MimetypeDescriptorRegistry)this.getExtensionPointRegistry(MIMETYPE_XP);
    }

    @Deprecated(since="11.1", forRemoval=true)
    protected boolean isMimetypeEntry(String mimetypeName) {
        return this.isMimeTypeNormalized(mimetypeName);
    }

    @Override
    public List<String> getExtensionsFromMimetypeName(String mimetypeName) {
        return this.getMimetypeRegistry().getEntryKeys().stream().filter(e -> ((MimetypeEntry)e.getValue()).getMimetypes().contains(mimetypeName)).flatMap(e -> ((MimetypeEntry)e.getValue()).getExtensions().stream()).collect(Collectors.toList());
    }

    @Override
    public MimetypeEntry getMimetypeEntryByName(String name) {
        return this.getMimetypeRegistry().getEntryByName(name);
    }

    @Override
    public String getMimetypeFromFile(File file) {
        if (file.length() > 0xA00000L) {
            String exceptionMessage = "Not able to determine mime type from filename and file is too big for binary scan.";
            if (file.getAbsolutePath() == null) {
                throw new MimetypeNotFoundException(exceptionMessage);
            }
            try {
                return this.getMimetypeFromFilename(file.getAbsolutePath());
            }
            catch (MimetypeNotFoundException e) {
                throw new MimetypeNotFoundException(exceptionMessage, (Throwable)((Object)e));
            }
        }
        try {
            String mimeType;
            MagicMatch match = Magic.getMagicMatch((File)file, (boolean)true, (boolean)false);
            if (match.getSubMatches().isEmpty()) {
                mimeType = match.getMimeType();
            } else {
                Collection possibilities = match.getSubMatches();
                Iterator iter = possibilities.iterator();
                MagicMatch m = (MagicMatch)iter.next();
                mimeType = m.getMimeType();
                possibilities.clear();
                match.setSubMatches(possibilities);
            }
            if ("text/plain".equals(mimeType)) {
                byte[] bytes = new byte[16];
                int n = 0;
                try (FileInputStream is = new FileInputStream(file);){
                    n = is.read(bytes);
                }
                for (int i = 0; i < n; ++i) {
                    if (bytes[i] != 0) continue;
                    mimeType = "application/octet-stream";
                    break;
                }
            }
            return mimeType;
        }
        catch (MagicMatchNotFoundException e) {
            if (file.getAbsolutePath() != null) {
                return this.getMimetypeFromFilename(file.getAbsolutePath());
            }
            throw new MimetypeNotFoundException(e.getMessage(), e);
        }
        catch (IOException | MagicException | MagicParseException e) {
            throw new MimetypeDetectionException(e.getMessage(), e);
        }
    }

    @Override
    public String getMimetypeFromExtension(String extension) {
        String lowerCaseExtension = extension.toLowerCase();
        Optional optExtensionDescriptor = this.getRegistryContribution(EXTENSION_XP, lowerCaseExtension);
        if (optExtensionDescriptor.isEmpty()) {
            MimetypeEntry mimetype = this.getMimetypeRegistry().getEntryByExtension(lowerCaseExtension);
            if (mimetype == null) {
                throw new MimetypeNotFoundException("no registered mimetype has extension: " + lowerCaseExtension);
            }
            return mimetype.getNormalized();
        }
        ExtensionDescriptor extensionDescriptor = (ExtensionDescriptor)optExtensionDescriptor.get();
        if (extensionDescriptor.isAmbiguous()) {
            throw new MimetypeNotFoundException(String.format("mimetype for %s is ambiguous, binary sniffing needed", lowerCaseExtension));
        }
        return extensionDescriptor.getMimetype();
    }

    @Override
    public String getMimetypeFromFilename(String filename) {
        if (filename == null) {
            throw new MimetypeNotFoundException("filename is null");
        }
        if (this.isTemporaryFile(filename)) {
            return "application/octet-stream";
        }
        String extension = FilenameUtils.getExtension((String)filename);
        if (StringUtils.isBlank((CharSequence)extension)) {
            throw new MimetypeNotFoundException(filename + "has no extension");
        }
        return this.getMimetypeFromExtension(extension);
    }

    protected boolean isTemporaryFile(String filename) {
        return FilenameUtils.getExtension((String)filename).equalsIgnoreCase(TMP_EXTENSION) || FilenameUtils.getName((String)filename).startsWith(MSOFFICE_TMP_PREFIX);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getMimetypeFromBlob(Blob blob) {
        if (blob.getLength() > 0xA00000L) {
            try {
                return this.getMimetypeFromFilename(blob.getFilename());
            }
            catch (MimetypeNotFoundException e) {
                throw new MimetypeNotFoundException("File is too big for binary scan");
            }
        }
        try {
            File file = Framework.createTempFile((String)"NXMimetypeBean", (String)".bin");
            try {
                String string;
                block15: {
                    InputStream is = blob.getStream();
                    try {
                        FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
                        string = this.getMimetypeFromFile(file);
                        if (is == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return string;
            }
            finally {
                if (file != null) {
                    Files.delete(file.toPath());
                }
            }
        }
        catch (IOException e) {
            throw new MimetypeDetectionException(e.getMessage(), e);
        }
    }

    @Override
    public MimetypeEntry getMimetypeEntryByMimeType(String mimetype) {
        return this.getMimetypeEntryByName(this.getNormalizedMimeType(mimetype).orElse("application/octet-stream"));
    }

    @Override
    public String getMimetypeFromBlobWithDefault(Blob blob, String defaultMimetype) {
        try {
            return this.getMimetypeFromBlob(blob);
        }
        catch (MimetypeNotFoundException e) {
            return defaultMimetype;
        }
    }

    @Override
    public String getMimetypeFromFilenameAndBlobWithDefault(String filename, Blob blob, String defaultMimetype) {
        try {
            return this.getMimetypeFromFilename(filename);
        }
        catch (MimetypeNotFoundException e) {
            return this.getMimetypeFromBlobWithDefault(blob, defaultMimetype);
        }
    }

    @Override
    public String getMimetypeFromFilenameWithBlobMimetypeFallback(String filename, Blob blob, String defaultMimetype) {
        try {
            return this.getMimetypeFromFilename(filename);
        }
        catch (MimetypeNotFoundException e) {
            String mimeTypeName = blob.getMimeType();
            if (this.isMimeTypeNormalized(mimeTypeName)) {
                return mimeTypeName;
            }
            return this.getMimetypeFromBlobWithDefault(blob, defaultMimetype);
        }
    }

    @Override
    public Blob updateMimetype(Blob blob, String filename, Boolean withBlobMimetypeFallback) {
        if (filename == null) {
            filename = blob.getFilename();
        } else if (blob.getFilename() == null) {
            blob.setFilename(filename);
        }
        if (Boolean.TRUE.equals(withBlobMimetypeFallback)) {
            blob.setMimeType(this.getMimetypeFromFilenameWithBlobMimetypeFallback(filename, blob, "application/octet-stream"));
        } else {
            blob.setMimeType(this.getMimetypeFromFilenameAndBlobWithDefault(filename, blob, "application/octet-stream"));
        }
        return blob;
    }

    @Override
    public Blob updateMimetype(Blob blob, String filename) {
        return this.updateMimetype(blob, filename, false);
    }

    @Override
    public Blob updateMimetype(Blob blob) {
        return this.updateMimetype(blob, null);
    }

    @Override
    public Optional<String> getNormalizedMimeType(String mimeType) {
        if (mimeType == null) {
            return Optional.empty();
        }
        return this.getMimetypeRegistry().getEntryKeys().stream().filter(e -> ((String)e.getKey()).equals(mimeType) || ((MimetypeEntry)e.getValue()).getMimetypes().contains(mimeType)).findAny().map(Map.Entry::getKey);
    }

    @Override
    public boolean isMimeTypeNormalized(String mimeType) {
        return this.getMimetypeRegistry().isNormalized(mimeType);
    }
}

