/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.Environment;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;

@XObject(value="environment")
@XRegistry
public class EnvironmentDescriptor {
    @XNode(value="@name", defaultAssignment="")
    @XRegistryId
    protected String name;
    @XNode(value="workingDirectory")
    protected String workingDirectory;
    @XNodeMap(value="parameters/parameter", key="@name", type=HashMap.class, componentType=String.class)
    private Map<String, String> parameters = new HashMap<String, String>();

    public String getWorkingDirectory() {
        if (this.workingDirectory == null) {
            this.workingDirectory = Environment.getDefault().getTemp().getPath();
        }
        if (!this.workingDirectory.endsWith("/")) {
            this.workingDirectory = this.workingDirectory + "/";
        }
        return this.workingDirectory;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getName() {
        return this.name;
    }

    public EnvironmentDescriptor merge(EnvironmentDescriptor other) {
        if (other != null) {
            if (other.workingDirectory != null) {
                this.workingDirectory = other.workingDirectory;
            }
            this.parameters.putAll(other.getParameters());
        }
        return this;
    }
}

