/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;

@XObject(value="renditionDefinition")
@XRegistry(enable=false)
public class RenditionDefinition {
    private static final Logger log = LogManager.getLogger(RenditionDefinition.class);
    public static final String DEFAULT_SOURCE_DOCUMENT_MODIFICATION_DATE_PROPERTY_NAME = "dc:modified";
    @XNode(value="@name")
    @XRegistryId
    protected String name;
    @XNode(value="@cmisName")
    protected String cmisName;
    @XNode(value="@enable", fallback="@enabled", defaultAssignment="true")
    @XEnable
    protected Boolean enabled;
    @XNode(value="label")
    protected String label;
    @XNode(value="icon")
    protected String icon;
    @XNode(value="kind")
    protected String kind;
    @XNode(value="operationChain")
    protected String operationChain;
    @XNode(value="allowEmptyBlob")
    protected Boolean allowEmptyBlob;
    @XNode(value="@visible")
    protected Boolean visible;
    @XNode(value="@class")
    protected Class<? extends RenditionProvider> providerClass;
    protected RenditionProvider provider;
    @XNode(value="contentType")
    protected String contentType;
    @XNodeList(value="filters/filter-id", type=ArrayList.class, componentType=String.class)
    protected List<String> filterIds;
    @XNode(value="sourceDocumentModificationDatePropertyName")
    protected String sourceDocumentModificationDatePropertyName;
    @XNode(value="storeByDefault")
    protected Boolean storeByDefault;
    @XNode(value="variantPolicy")
    protected String variantPolicy;

    private static boolean defaultTrue(Boolean bool) {
        return !Boolean.FALSE.equals(bool);
    }

    private static boolean defaultFalse(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCmisName() {
        return this.cmisName;
    }

    public void setCmisName(String cmisName) {
        this.cmisName = cmisName;
    }

    public boolean isEnabled() {
        return RenditionDefinition.defaultTrue(this.enabled);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getOperationChain() {
        return this.operationChain;
    }

    public void setOperationChain(String operationChain) {
        this.operationChain = operationChain;
    }

    public boolean isEmptyBlobAllowed() {
        return RenditionDefinition.defaultFalse(this.allowEmptyBlob);
    }

    public void setAllowEmptyBlob(boolean allowEmptyBlob) {
        this.allowEmptyBlob = allowEmptyBlob;
    }

    public boolean isVisible() {
        return RenditionDefinition.defaultTrue(this.visible);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Class<? extends RenditionProvider> getProviderClass() {
        return this.providerClass;
    }

    public void setProviderClass(Class<? extends RenditionProvider> providerClass) {
        this.providerClass = providerClass;
    }

    protected RenditionProvider createProvider() {
        if (this.providerClass != null) {
            try {
                return this.providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                log.error("Unable to create RenditionProvider for '{}'", (Object)this.getName(), (Object)e);
            }
        }
        return null;
    }

    public RenditionProvider getProvider() {
        if (this.provider != null) {
            return this.provider;
        }
        return this.createProvider();
    }

    public String getProviderType() {
        RenditionProvider provider = this.getProvider();
        if (provider == null) {
            return null;
        }
        return provider.getClass().getSimpleName();
    }

    public void setProvider(RenditionProvider provider) {
        this.provider = provider;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public List<String> getFilterIds() {
        return this.filterIds;
    }

    public void setFilterIds(List<String> filterIds) {
        this.filterIds = filterIds;
    }

    public String getSourceDocumentModificationDatePropertyName() {
        return StringUtils.defaultString((String)this.sourceDocumentModificationDatePropertyName, (String)DEFAULT_SOURCE_DOCUMENT_MODIFICATION_DATE_PROPERTY_NAME);
    }

    public void setSourceDocumentModificationDatePropertyName(String sourceDocumentModificationDatePropertyName) {
        this.sourceDocumentModificationDatePropertyName = sourceDocumentModificationDatePropertyName;
    }

    public boolean isStoreByDefault() {
        return RenditionDefinition.defaultFalse(this.storeByDefault);
    }

    public void setStoreByDefault(boolean storeByDefault) {
        this.storeByDefault = storeByDefault;
    }

    public String getVariantPolicy() {
        return this.variantPolicy;
    }

    public RenditionProvider initProvider() {
        this.provider = this.createProvider();
        return this.provider;
    }
}

