/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobStoreBlobProvider;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.KeyStrategyDigest;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ComputeDigestHelper {
    private static final Logger log = LogManager.getLogger(ComputeDigestHelper.class);
    public final String blobProviderId;
    public final String key;
    public String newKey;
    public String digest;

    public ComputeDigestHelper(String blobProviderId, String key) {
        this.blobProviderId = blobProviderId;
        this.key = key;
    }

    public void computeAndReplaceDigest() {
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        BlobProvider blobProvider = blobManager.getBlobProvider(this.blobProviderId);
        if (blobProvider == null) {
            throw new NuxeoException("Unknown blob provider");
        }
        if (!(blobProvider instanceof BlobStoreBlobProvider)) {
            throw new NuxeoException("Invalid blob provider class: " + blobProvider.getClass().getName());
        }
        BlobStore blobStore = ((BlobStoreBlobProvider)blobProvider).store;
        this.digest = this.computeDigest(blobStore);
        if (this.digest == null) {
            log.debug("Blob with key: {} was not found in blob provider: {}", (Object)this.key, (Object)this.blobProviderId);
            return;
        }
        if (this.digest.equals(this.key)) {
            return;
        }
        try {
            this.newKey = blobStore.copyOrMoveBlob(this.digest, blobStore, this.key, false);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        blobManager.setBlobKeyReplacement(this.blobProviderId, this.key, this.newKey);
        this.replaceDigestAllRepositories();
        blobStore.deleteBlob(this.key);
    }

    protected String computeDigest(BlobStore blobStore) {
        KeyStrategy keyStrategy = (blobStore = blobStore.unwrap()).getKeyStrategy();
        if (!(keyStrategy instanceof KeyStrategyDigest)) {
            throw new NuxeoException("Invalid key strategy class: " + keyStrategy.getClass().getName());
        }
        String digestAlgorithm = ((KeyStrategyDigest)keyStrategy).digestAlgorithm;
        Path tmp = null;
        try {
            tmp = Framework.createTempFilePath((String)"blobdigest_", (String)".tmp", (FileAttribute[])new FileAttribute[0]);
            if (!blobStore.readBlob(this.key, tmp)) {
                String string = null;
                return string;
            }
            String string = new DigestUtils(digestAlgorithm).digestAsHex(tmp.toFile());
            return string;
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to download blob", (Throwable)e);
        }
        finally {
            if (tmp != null) {
                try {
                    Files.deleteIfExists(tmp);
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    protected void replaceDigestAllRepositories() {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        if (repositoryManager == null) {
            return;
        }
        repositoryManager.getRepositoryNames().forEach(this::replaceDigest);
    }

    protected void replaceDigest(String repositoryName) {
        log.debug("Replacing blob key: {} with: {} in repository: {}", (Object)this.key, (Object)this.newKey, (Object)repositoryName);
        TransactionHelper.runInTransaction(() -> CoreInstance.doPrivileged((String)repositoryName, session -> this.replaceDigest((CoreSession)session)));
    }

    protected void replaceDigest(CoreSession session) {
        String prefixedKey = this.blobProviderId + ":" + this.key;
        String newPrefixedKey = this.blobProviderId + ":" + this.newKey;
        String query = "SELECT ecm:uuid FROM Document, Relation WHERE ecm:isProxy = 0 AND ecm:blobKeys IN (" + NXQL.escapeString((String)this.key) + ", " + NXQL.escapeString((String)prefixedKey) + ")";
        ArrayList docIds = new ArrayList();
        try (IterableQueryResult it = session.queryAndFetch(query, "NXQL", new Object[0]);){
            it.forEach(map -> docIds.add(((Serializable)map.get("ecm:uuid")).toString()));
        }
        log.debug("Documents with this blob key: {}", docIds);
        if (docIds.isEmpty()) {
            return;
        }
        docIds.forEach(docId -> {
            session.replaceBlobDigest((DocumentRef)new IdRef(docId), this.key, this.newKey, this.digest);
            session.replaceBlobDigest((DocumentRef)new IdRef(docId), prefixedKey, newPrefixedKey, this.digest);
        });
        session.save();
    }
}

