/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.ComputeDigestHelper;
import org.nuxeo.ecm.core.work.AbstractWork;

public class ComputeDigestWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    public final String blobProviderId;
    public final String key;

    public ComputeDigestWork(String blobProviderId, String key) {
        this.blobProviderId = blobProviderId;
        this.key = key;
    }

    public String getTitle() {
        return "Compute digest work";
    }

    public String getCategory() {
        return "computeDigest";
    }

    public void work() {
        try {
            new ComputeDigestHelper(this.blobProviderId, this.key).computeAndReplaceDigest();
        }
        catch (NuxeoException e) {
            e.addInfo("For blob provider: " + this.blobProviderId + " and key: " + this.key);
            throw e;
        }
    }
}

