/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleState;
import org.nuxeo.ecm.core.lifecycle.extensions.LifeCycleDescriptor;
import org.nuxeo.ecm.core.lifecycle.impl.LifeCycleImpl;

public class LifeCycleRegistry
extends MapRegistry {
    private static final Logger log = LogManager.getLogger(LifeCycleRegistry.class);
    protected Map<String, LifeCycle> lifeCycles = new ConcurrentHashMap<String, LifeCycle>();

    public void initialize() {
        super.initialize();
        this.lifeCycles.clear();
        this.lifeCycles.putAll((Map<String, LifeCycle>)this.getContributionValues().stream().collect(Collectors.toConcurrentMap(LifeCycleDescriptor::getName, this::getLifeCycle)));
    }

    public LifeCycle getLifeCycle(String name) {
        if (name == null) {
            return null;
        }
        this.checkInitialized();
        return this.lifeCycles.get(name);
    }

    public Collection<LifeCycle> getLifeCycles() {
        this.checkInitialized();
        return this.lifeCycles.values();
    }

    public LifeCycle getLifeCycle(LifeCycleDescriptor desc) {
        this.checkInitialized();
        String name = desc.getName();
        String initialStateName = desc.getInitialStateName();
        String defaultInitialStateName = desc.getDefaultInitialStateName();
        if (initialStateName != null) {
            defaultInitialStateName = initialStateName;
            log.warn("Lifecycle registration of default initial state has changed, change initial=\"{}\" to defaultInitial=\"{}\" in lifecyle '{}' definition", (Object)defaultInitialStateName, (Object)defaultInitialStateName, (Object)name);
        }
        boolean defaultInitialStateFound = false;
        HashSet<String> initialStateNames = new HashSet<String>();
        Collection<LifeCycleState> states = desc.getStates();
        for (LifeCycleState state : states) {
            String stateName = state.getName();
            if (defaultInitialStateName.equals(stateName)) {
                defaultInitialStateFound = true;
                initialStateNames.add(stateName);
            }
            if (!state.isInitial()) continue;
            initialStateNames.add(stateName);
        }
        if (!defaultInitialStateFound) {
            log.error("Default initial state '{}' not found on lifecycle '{}'", (Object)defaultInitialStateName, (Object)name);
        }
        if (!"default".equals(desc.getName()) && desc.getStates().stream().map(LifeCycleState::getName).anyMatch(Predicate.isEqual("deleted"))) {
            log.warn("The 'deleted' state is deprecated and shouldn't be use anymore. Please consider removing it from you life cycle policy and use trash service instead.");
        }
        return new LifeCycleImpl(name, defaultInitialStateName, initialStateNames, states, desc.getTransitions());
    }
}

