/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.api.security.UserVisiblePermission;
import org.nuxeo.ecm.core.security.PermissionDescriptor;
import org.nuxeo.ecm.core.security.PermissionVisibilityDescriptor;

public class DefaultPermissionProvider
implements PermissionProvider {
    protected final Map<String, PermissionDescriptor> permissions;
    protected final Map<String, Set<String>> groups;
    protected final Map<String, PermissionVisibilityDescriptor> visibility;

    public DefaultPermissionProvider(Map<String, PermissionDescriptor> permissions, Map<String, PermissionVisibilityDescriptor> visibility) {
        this.checkPermissions(permissions);
        this.permissions = permissions;
        this.groups = this.computeGroups(permissions);
        this.visibility = visibility;
    }

    public List<UserVisiblePermission> getUserVisiblePermissionDescriptors(String typeName) {
        PermissionVisibilityDescriptor defaultVisibility = this.visibility.getOrDefault(typeName, this.visibility.get(""));
        if (defaultVisibility == null) {
            throw new NuxeoException(String.format("No permission visibility configuration registered for type '%s'", typeName));
        }
        return defaultVisibility.getSortedUIPermissionDescriptor();
    }

    public List<UserVisiblePermission> getUserVisiblePermissionDescriptors() {
        return this.getUserVisiblePermissionDescriptors("");
    }

    public Map<String, PermissionVisibilityDescriptor> getPermissionsVisibility() {
        return Collections.unmodifiableMap(this.visibility);
    }

    public String[] getSubPermissions(String perm) {
        List<String> permissions = this.getPermission(perm).getSubPermissions();
        return permissions.toArray(new String[permissions.size()]);
    }

    @Deprecated(since="11.5")
    public String[] getAliasPermissions(String perm) {
        List<String> permissions = this.getPermission(perm).getAliasPermissions();
        return permissions.toArray(new String[permissions.size()]);
    }

    protected PermissionDescriptor getPermission(String perm) {
        PermissionDescriptor mpd = this.permissions.get(perm);
        if (mpd == null) {
            throw new NuxeoException(perm + " is not a registered permission");
        }
        return mpd;
    }

    public synchronized String[] getPermissionGroups(String perm) {
        Set<String> groupList = this.groups.get(perm);
        if (groupList != null) {
            return groupList.toArray(new String[groupList.size()]);
        }
        return new String[0];
    }

    protected Map<String, Set<String>> computeGroups(Map<String, PermissionDescriptor> permissions) {
        TreeSet<String> groups;
        HashMap<String, Set<String>> mergedGroups = new HashMap<String, Set<String>>();
        for (PermissionDescriptor mpd : permissions.values()) {
            for (String subPermission : mpd.getSubPermissions()) {
                groups = (TreeSet<String>)mergedGroups.get(subPermission);
                if (groups == null) {
                    groups = new TreeSet<String>();
                    groups.add(mpd.getName());
                    mergedGroups.put(subPermission, groups);
                    continue;
                }
                if (groups.contains(mpd.getName())) continue;
                groups.add(mpd.getName());
            }
        }
        HashSet<String> alreadyProcessed = new HashSet<String>();
        for (Map.Entry groupEntry : mergedGroups.entrySet()) {
            String permissionName = (String)groupEntry.getKey();
            groups = (Set)groupEntry.getValue();
            Set<String> allGroups = this.computeAllGroups(mergedGroups, permissionName, alreadyProcessed);
            groups.addAll(allGroups);
        }
        return mergedGroups;
    }

    protected Set<String> computeAllGroups(Map<String, Set<String>> mergedGroups, String permissionName, Set<String> alreadyProcessed) {
        Set<String> allGroups = mergedGroups.get(permissionName);
        if (allGroups == null) {
            allGroups = new TreeSet<String>();
        }
        if (alreadyProcessed.contains(permissionName)) {
            return allGroups;
        }
        alreadyProcessed.add(permissionName);
        for (String directGroupName : new TreeSet<String>(allGroups)) {
            allGroups.addAll(this.computeAllGroups(mergedGroups, directGroupName, alreadyProcessed));
        }
        return allGroups;
    }

    public synchronized String[] getPermissions() {
        return this.permissions.keySet().toArray(new String[this.permissions.size()]);
    }

    protected void checkPermissions(Map<String, PermissionDescriptor> permissions) {
        for (PermissionDescriptor p : permissions.values()) {
            List unknownPermissions = p.getSubPermissions().stream().filter(Predicate.not(permissions::containsKey)).collect(Collectors.toList());
            if (unknownPermissions.isEmpty()) continue;
            throw new NuxeoException(String.format("Permission(s) %s included by '%s' are unknown", unknownPermissions, p.getName()));
        }
    }
}

