/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;

@XObject(value="permission")
@XRegistry
public class PermissionDescriptor {
    @XNode(value="@name")
    @XRegistryId
    private String name;
    @XNodeList(value="include", type=String[].class, componentType=String.class)
    private String[] includePermissions;
    @XNodeList(value="remove", type=String[].class, componentType=String.class)
    private String[] removePermissions;
    @Deprecated(since="11.5")
    @XNodeList(value="alias", type=String[].class, componentType=String.class)
    private String[] aliasPermissions;

    public String getName() {
        return this.name;
    }

    public List<String> getSubPermissions() {
        List<String> removed = this.getRemovePermissions();
        return this.getIncludePermissions().stream().filter(Predicate.not(removed::contains)).distinct().collect(Collectors.toList());
    }

    public List<String> getIncludePermissions() {
        return Arrays.asList(this.includePermissions);
    }

    public List<String> getRemovePermissions() {
        return Arrays.asList(this.removePermissions);
    }

    @Deprecated(since="11.5")
    public List<String> getAliasPermissions() {
        return Arrays.asList(this.aliasPermissions);
    }

    public String toString() {
        return String.format("PermissionDescriptor[%s]", this.name);
    }
}

