/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;

@XObject(value="item")
public class PermissionUIItemDescriptor {
    @XNode
    private String permission;
    @XNode(value="@show")
    private Boolean show;
    @XNode(value="@order")
    private Integer order;
    @XNode(value="@denyPermission")
    private String denyPermission;

    public PermissionUIItemDescriptor() {
    }

    public PermissionUIItemDescriptor(PermissionUIItemDescriptor referenceDescriptor) {
        this.show = referenceDescriptor.show;
        this.order = referenceDescriptor.order;
        this.permission = referenceDescriptor.permission;
        this.denyPermission = referenceDescriptor.denyPermission;
    }

    public int getOrder() {
        return Objects.requireNonNullElse(this.order, 0);
    }

    public boolean isShown() {
        return !Boolean.FALSE.equals(this.show);
    }

    public String getPermission() {
        return this.permission;
    }

    public String getDenyPermission() {
        return Objects.requireNonNullElse(this.denyPermission, this.permission);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public void merge(PermissionUIItemDescriptor pid) {
        if (!this.permission.equals(pid.permission)) {
            throw new NuxeoException(String.format("cannot merge permission item '%s' with '%s'", this.permission, pid.permission));
        }
        this.show = pid.show != null ? pid.show : this.show;
        this.order = pid.order != null ? pid.order : this.order;
        this.denyPermission = pid.denyPermission != null ? pid.denyPermission : this.denyPermission;
    }

    public String toString() {
        if (this.denyPermission != null) {
            return String.format("PermissionUIItemDescriptor[%s (deny %s)]", this.permission, this.denyPermission);
        }
        return String.format("PermissionUIItemDescriptor[%s]", this.permission);
    }
}

