/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.DefaultPermissionProvider;
import org.nuxeo.ecm.core.security.SecurityPolicyService;
import org.nuxeo.ecm.core.security.SecurityPolicyServiceImpl;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class SecurityService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.security.SecurityService");
    private static final String PERMISSIONS_EXTENSION_POINT = "permissions";
    private static final String PERMISSIONS_VISIBILITY_EXTENSION_POINT = "permissionsVisibility";
    private static final String POLICIES_EXTENSION_POINT = "policies";
    private PermissionProvider permissionProvider;
    private SecurityPolicyService securityPolicyService;

    public int getApplicationStartedOrder() {
        return 99;
    }

    public void start(ComponentContext context) {
        Map permissions = ((MapRegistry)this.getExtensionPointRegistry(PERMISSIONS_EXTENSION_POINT)).getContributions();
        Map visibility = ((MapRegistry)this.getExtensionPointRegistry(PERMISSIONS_VISIBILITY_EXTENSION_POINT)).getContributions();
        this.permissionProvider = new DefaultPermissionProvider(permissions, visibility);
        this.securityPolicyService = new SecurityPolicyServiceImpl(this.getRegistryContributions(POLICIES_EXTENSION_POINT));
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.permissionProvider = null;
        this.securityPolicyService = null;
    }

    public PermissionProvider getPermissionProvider() {
        return this.permissionProvider;
    }

    public boolean arePoliciesRestrictingPermission(String permission) {
        return this.securityPolicyService.arePoliciesRestrictingPermission(permission);
    }

    public boolean arePoliciesExpressibleInQuery(String repositoryName) {
        return this.securityPolicyService.arePoliciesExpressibleInQuery(repositoryName);
    }

    public Collection<SQLQuery.Transformer> getPoliciesQueryTransformers(String repositoryName) {
        return this.securityPolicyService.getPoliciesQueryTransformers(repositoryName);
    }

    public boolean checkPermission(Document doc, NuxeoPrincipal principal, String permission) {
        if (principal.isAdministrator()) {
            return true;
        }
        String[] resolvedPermissions = this.getPermissionsToCheck(permission);
        String[] additionalPrincipals = SecurityService.getPrincipalsToCheck(principal);
        ACP acp = doc.getSession().getMergedACP(doc);
        Access access = this.securityPolicyService.checkPermission(doc, acp, principal, permission, resolvedPermissions, additionalPrincipals);
        if (access != null && !Access.UNKNOWN.equals(access)) {
            return access.toBoolean();
        }
        if (acp == null) {
            return false;
        }
        access = acp.getAccess(additionalPrincipals, resolvedPermissions);
        return access.toBoolean();
    }

    public Collection<String> filterGrantedPermissions(Document doc, NuxeoPrincipal principal, Collection<String> permissions) {
        if (principal.isAdministrator()) {
            return permissions;
        }
        String[] additionalPrincipals = SecurityService.getPrincipalsToCheck(principal);
        ACP acp = doc.getSession().getMergedACP(doc);
        ArrayList<String> result = new ArrayList<String>();
        for (String permission : permissions) {
            String[] resolvedPermissions;
            Access access = this.securityPolicyService.checkPermission(doc, acp, principal, permission, resolvedPermissions = this.getPermissionsToCheck(permission), additionalPrincipals);
            if (access == null || Access.UNKNOWN.equals(access)) {
                Access access2 = access = acp == null ? null : acp.getAccess(additionalPrincipals, resolvedPermissions);
            }
            if (access == null || !access.toBoolean()) continue;
            result.add(permission);
        }
        return result;
    }

    public String[] getPermissionsToCheck(String permission) {
        String[] groups = this.permissionProvider.getPermissionGroups(permission);
        if (groups == null) {
            return new String[]{permission, "Everything"};
        }
        String[] perms = new String[groups.length + 2];
        perms[0] = permission;
        System.arraycopy(groups, 0, perms, 1, groups.length);
        perms[groups.length + 1] = "Everything";
        return perms;
    }

    public static String[] getPrincipalsToCheck(NuxeoPrincipal principal) {
        List userGroups = principal.getAllGroups();
        if (userGroups == null) {
            return new String[]{principal.getName(), "Everyone"};
        }
        int size = userGroups.size();
        String[] groups = new String[size + 2];
        userGroups.toArray(groups);
        groups[size] = principal.getName();
        groups[size + 1] = "Everyone";
        return groups;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(PermissionProvider.class)) {
            return (T)this.permissionProvider;
        }
        if (adapter.isAssignableFrom(SecurityPolicyService.class)) {
            return (T)this.securityPolicyService;
        }
        return adapter.cast((Object)this);
    }
}

